/*
 * Decompiled with CFR 0.152.
 */
package org.proshin.finapi.bankconnection;

import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.http.NameValuePair;
import org.json.JSONArray;
import org.json.JSONObject;
import org.proshin.finapi.accesstoken.AccessToken;
import org.proshin.finapi.bankconnection.BankConnection;
import org.proshin.finapi.bankconnection.BankConnections;
import org.proshin.finapi.bankconnection.FpBankConnection;
import org.proshin.finapi.bankconnection.in.ImportParameters;
import org.proshin.finapi.bankconnection.in.UpdateParameters;
import org.proshin.finapi.endpoint.Endpoint;
import org.proshin.finapi.primitives.IterableJsonArray;
import org.proshin.finapi.primitives.pair.CommaSeparatedPair;

public final class FpBankConnections
implements BankConnections {
    private final Endpoint endpoint;
    private final AccessToken token;

    public FpBankConnections(Endpoint endpoint, AccessToken token) {
        this.endpoint = endpoint;
        this.token = token;
    }

    @Override
    public BankConnection one(Long id) {
        return new FpBankConnection(this.endpoint, this.token, new JSONObject(this.endpoint.get(String.format("/api/v1/bankConnections/%d", id), this.token, new NameValuePair[0])));
    }

    @Override
    public Iterable<BankConnection> query(Iterable<Long> ids) {
        return new IterableJsonArray<BankConnection>(new JSONObject(this.endpoint.get("/api/v1/bankConnections", this.token, new CommaSeparatedPair<Long>("ids", ids))).getJSONArray("connections"), (array, index) -> new FpBankConnection(this.endpoint, this.token, array.getJSONObject(index.intValue())));
    }

    @Override
    public Future<BankConnection> importNew(ImportParameters parameters) {
        return Executors.newSingleThreadExecutor().submit(() -> new FpBankConnection(this.endpoint, this.token, new JSONObject(this.endpoint.post("/api/v1/bankConnections/import", this.token, parameters, 201))));
    }

    @Override
    public Future<BankConnection> update(UpdateParameters parameters) {
        return Executors.newSingleThreadExecutor().submit(() -> new FpBankConnection(this.endpoint, this.token, new JSONObject(this.endpoint.post("/api/v1/bankConnections/update", this.token, parameters))));
    }

    @Override
    public Iterable<Long> deleteAll() {
        return new IterableJsonArray<Long>(new JSONObject(this.endpoint.delete("/api/v1/bankConnections", this.token, new NameValuePair[0])).getJSONArray("identifiers"), JSONArray::getLong);
    }
}

