/*
 * Decompiled with CFR 0.152.
 */
package org.proshin.finapi.category.in;

import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.http.NameValuePair;
import org.proshin.finapi.primitives.Direction;
import org.proshin.finapi.primitives.StringOf;
import org.proshin.finapi.primitives.pair.CommaSeparatedPair;
import org.proshin.finapi.primitives.pair.UrlEncodedPair;

public final class CashFlowsCriteria
implements Iterable<NameValuePair> {
    private final List<NameValuePair> pairs;

    public CashFlowsCriteria() {
        this(new ArrayList<NameValuePair>());
    }

    public CashFlowsCriteria(List<NameValuePair> pairs) {
        this.pairs = pairs;
    }

    public CashFlowsCriteria withSearch(String search) {
        this.pairs.add(new UrlEncodedPair("search", search));
        return this;
    }

    public CashFlowsCriteria withCounterpart(String counterpart) {
        this.pairs.add(new UrlEncodedPair("counterpart", counterpart));
        return this;
    }

    public CashFlowsCriteria withPurpose(String purpose) {
        this.pairs.add(new UrlEncodedPair("purpose", purpose));
        return this;
    }

    public CashFlowsCriteria withAccounts(Iterable<Long> accounts) {
        this.pairs.add(new UrlEncodedPair(new CommaSeparatedPair<Long>("accountIds", accounts)));
        return this;
    }

    public CashFlowsCriteria withMinBankBookingDate(OffsetDateTime minBankBookingDate) {
        this.pairs.add(new UrlEncodedPair("minBankBookingDate", new StringOf(minBankBookingDate)));
        return this;
    }

    public CashFlowsCriteria withMaxBankBookingDate(OffsetDateTime maxBankBookingDate) {
        this.pairs.add(new UrlEncodedPair("maxBankBookingDate", new StringOf(maxBankBookingDate)));
        return this;
    }

    public CashFlowsCriteria withMinFinapiBookingDate(OffsetDateTime minFinapiBookingDate) {
        this.pairs.add(new UrlEncodedPair("minFinapiBookingDate", new StringOf(minFinapiBookingDate)));
        return this;
    }

    public CashFlowsCriteria withMaxFinapiBookingDate(OffsetDateTime maxFinapiBookingDate) {
        this.pairs.add(new UrlEncodedPair("maxFinapiBookingDate", new StringOf(maxFinapiBookingDate)));
        return this;
    }

    public CashFlowsCriteria withMinAmount(BigDecimal minAmount) {
        this.pairs.add(new UrlEncodedPair("minAmount", new StringOf(minAmount)));
        return this;
    }

    public CashFlowsCriteria withMaxAmount(BigDecimal maxAmount) {
        this.pairs.add(new UrlEncodedPair("maxAmount", new StringOf(maxAmount)));
        return this;
    }

    public CashFlowsCriteria withDirection(Direction direction) {
        this.pairs.add(new UrlEncodedPair("direction", direction.lowerCase()));
        return this;
    }

    public CashFlowsCriteria withLabels(Iterable<Long> labels) {
        this.pairs.add(new UrlEncodedPair(new CommaSeparatedPair<Long>("labelIds", labels)));
        return this;
    }

    public CashFlowsCriteria withCategories(Iterable<Long> categories) {
        this.pairs.add(new UrlEncodedPair(new CommaSeparatedPair<Long>("categoryIds", categories)));
        return this;
    }

    public CashFlowsCriteria withIsNew(boolean isNew) {
        this.pairs.add(new UrlEncodedPair("isNew", isNew));
        return this;
    }

    public CashFlowsCriteria withMinImportDate(OffsetDateTime minImportDate) {
        this.pairs.add(new UrlEncodedPair("minImportDate", new StringOf(minImportDate)));
        return this;
    }

    public CashFlowsCriteria withMaxImportDate(OffsetDateTime maxImportDate) {
        this.pairs.add(new UrlEncodedPair("maxImportDate", new StringOf(maxImportDate)));
        return this;
    }

    public CashFlowsCriteria withoutSubCashFlows() {
        this.pairs.add(new UrlEncodedPair("includeSubCashFlows", false));
        return this;
    }

    public CashFlowsCriteria withOrdering(String ... orders) {
        for (String order : orders) {
            this.pairs.add(new UrlEncodedPair("order", order));
        }
        return this;
    }

    @Override
    public Iterator<NameValuePair> iterator() {
        return this.pairs.iterator();
    }
}

