/*
 * Decompiled with CFR 0.152.
 */
package org.proshin.finapi.primitives;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public final class StringOf
implements Supplier<String> {
    private final String origin;

    public StringOf(OffsetDateTime value) {
        this(DateTimeFormatter.ofPattern("yyyy-MM-dd").withZone(ZoneId.of("Europe/Berlin")).format(value));
    }

    public StringOf(BigDecimal value) {
        this(((Supplier<String>)() -> {
            DecimalFormat df = (DecimalFormat)NumberFormat.getNumberInstance(Locale.ENGLISH);
            df.applyPattern("###.##");
            return df.format(value);
        }).get());
    }

    public StringOf(Iterable<Long> items) {
        this(items, ",");
    }

    public StringOf(Iterable<Long> items, CharSequence delimiter) {
        this(StreamSupport.stream(items.spliterator(), false).map(Object::toString).collect(Collectors.joining(delimiter)));
    }

    public StringOf(String origin) {
        this.origin = origin;
    }

    @Override
    public String get() {
        return this.origin;
    }

    public String toString() {
        return this.get();
    }
}

