/*
 * Decompiled with CFR 0.152.
 */
package org.proshin.finapi.transaction;

import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.util.Optional;
import org.proshin.finapi.category.Category;
import org.proshin.finapi.label.Label;
import org.proshin.finapi.transaction.in.EditTransactionParameters;
import org.proshin.finapi.transaction.in.SplitTransactionParameters;
import org.proshin.finapi.transaction.out.Counterpart;
import org.proshin.finapi.transaction.out.PayPalData;
import org.proshin.finapi.transaction.out.Type;

public interface Transaction {
    public Long id();

    public Optional<Long> parent();

    public Long account();

    public OffsetDateTime valueDate();

    public OffsetDateTime bankBookingDate();

    public OffsetDateTime finapiBookingDate();

    public BigDecimal amount();

    public Optional<String> purpose();

    public Counterpart counterpart();

    public Type type();

    public Optional<String> sepaPurposeCode();

    public Optional<String> primanota();

    public Optional<Category> category();

    public Iterable<Label> labels();

    public boolean isPotentialDuplicate();

    public boolean isAdjustingEntry();

    public boolean isNew();

    public OffsetDateTime importDate();

    public Iterable<Long> children();

    public Optional<PayPalData> payPalData();

    public Optional<String> endToEndReference();

    public Transaction split(SplitTransactionParameters var1);

    public Transaction restore();

    public Transaction edit(EditTransactionParameters var1);

    public void delete();
}

