/*
 * Decompiled with CFR 0.152.
 */
package org.proshin.finapi.transaction.in;

import java.math.BigDecimal;
import org.json.JSONObject;
import org.proshin.finapi.Jsonable;

public final class Subtransaction
implements Jsonable {
    private final JSONObject origin;

    public Subtransaction() {
        this(new JSONObject());
    }

    public Subtransaction(JSONObject origin) {
        this.origin = origin;
    }

    public Subtransaction withAmount(BigDecimal amount) {
        this.origin.put("amount", (Object)amount);
        return this;
    }

    public Subtransaction withCategory(Long category) {
        this.origin.put("categoryId", (Object)category);
        return this;
    }

    public Subtransaction withPurpose(String purpose) {
        this.origin.put("purpose", (Object)purpose);
        return this;
    }

    public Subtransaction withCounterpart(String counterpart) {
        this.origin.put("counterpart", (Object)counterpart);
        return this;
    }

    public Subtransaction withCounterpartAccountNumber(String accountNumber) {
        this.origin.put("counterpartAccountNumber", (Object)accountNumber);
        return this;
    }

    public Subtransaction withCounterpartIban(String iban) {
        this.origin.put("counterpartIban", (Object)iban);
        return this;
    }

    public Subtransaction withCounterpartBic(String bic) {
        this.origin.put("counterpartBic", (Object)bic);
        return this;
    }

    public Subtransaction withCounterpartBlz(String blz) {
        this.origin.put("counterpartBlz", (Object)blz);
        return this;
    }

    public Subtransaction withLabels(Iterable<Long> labels) {
        for (Long label : labels) {
            this.origin.append("labelIds", (Object)label);
        }
        return this;
    }

    @Override
    public JSONObject asJson() {
        return this.origin;
    }
}

