/*
 * Decompiled with CFR 0.152.
 */
package org.proshin.finapi.account;

import org.json.JSONObject;
import org.proshin.finapi.accesstoken.AccessToken;
import org.proshin.finapi.account.MoneyTransfer;
import org.proshin.finapi.account.in.MoneyTransferParameters;
import org.proshin.finapi.account.out.FpSepaExecutingResponse;
import org.proshin.finapi.account.out.FpSepaRequestingResponse;
import org.proshin.finapi.account.out.SepaExecutingResponse;
import org.proshin.finapi.account.out.SepaRequestingResponse;
import org.proshin.finapi.endpoint.Endpoint;

public final class FpMoneyTransfer
implements MoneyTransfer {
    private final Endpoint endpoint;
    private final AccessToken token;
    private final String url;

    public FpMoneyTransfer(Endpoint endpoint, AccessToken token, String url) {
        this.endpoint = endpoint;
        this.token = token;
        this.url = url;
    }

    @Override
    public SepaRequestingResponse request(MoneyTransferParameters parameters) {
        return new FpSepaRequestingResponse(new JSONObject(this.endpoint.post(this.url + "requestSepaMoneyTransfer", this.token, parameters)));
    }

    @Override
    public SepaExecutingResponse execute(Long account, String bankingTan) {
        return new FpSepaExecutingResponse(new JSONObject(this.endpoint.post(this.url + "executeSepaMoneyTransfer", this.token, () -> new JSONObject().put("accountId", (Object)account).put("bankingTan", (Object)bankingTan))));
    }
}

