/*
 * Decompiled with CFR 0.152.
 */
package org.proshin.finapi.account.in;

import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.http.NameValuePair;
import org.proshin.finapi.primitives.StringOf;
import org.proshin.finapi.primitives.pair.CommaSeparatedPair;
import org.proshin.finapi.primitives.pair.UrlEncodedPair;

public final class DailyBalancesCriteria
implements Iterable<NameValuePair> {
    private final List<NameValuePair> pairs;

    public DailyBalancesCriteria() {
        this(new ArrayList<NameValuePair>());
    }

    public DailyBalancesCriteria(List<NameValuePair> pairs) {
        this.pairs = pairs;
    }

    public DailyBalancesCriteria withAccounts(Iterable<Long> accounts) {
        this.pairs.add(new UrlEncodedPair(new CommaSeparatedPair<Long>("accountIds", accounts)));
        return this;
    }

    public DailyBalancesCriteria withStartDate(OffsetDateTime startDate) {
        this.pairs.add(new UrlEncodedPair("startDate", new StringOf(startDate)));
        return this;
    }

    public DailyBalancesCriteria withEndDate(OffsetDateTime endDate) {
        this.pairs.add(new UrlEncodedPair("endDate", new StringOf(endDate)));
        return this;
    }

    public DailyBalancesCriteria withProjection() {
        this.pairs.add(new UrlEncodedPair("withProjection", false));
        return this;
    }

    public DailyBalancesCriteria withPage(int page, int perPage) {
        this.pairs.add(new UrlEncodedPair("page", page));
        this.pairs.add(new UrlEncodedPair("perPage", perPage));
        return this;
    }

    public DailyBalancesCriteria orderBy(String ... orders) {
        for (String order : orders) {
            this.pairs.add(new UrlEncodedPair("order", order));
        }
        return this;
    }

    @Override
    public Iterator<NameValuePair> iterator() {
        return this.pairs.iterator();
    }
}

