/*
 * Decompiled with CFR 0.152.
 */
package org.proshin.finapi.account.in;

import java.math.BigDecimal;
import java.time.OffsetDateTime;
import org.json.JSONObject;
import org.proshin.finapi.Jsonable;
import org.proshin.finapi.primitives.StringOf;

public final class DirectDebitParameters
implements Jsonable {
    private final JSONObject origin;

    public DirectDebitParameters() {
        this(new JSONObject());
    }

    public DirectDebitParameters(JSONObject origin) {
        this.origin = origin;
    }

    public DirectDebitParameters withAccount(Long account) {
        this.origin.put("accountId", (Object)account);
        return this;
    }

    public DirectDebitParameters withBankingPin(String bankingPin) {
        this.origin.put("bankingPin", (Object)bankingPin);
        return this;
    }

    public DirectDebitParameters withStoringPin() {
        this.origin.put("storePin", true);
        return this;
    }

    public DirectDebitParameters withTwoStepProcedure(String id) {
        this.origin.put("twoStepProcedureId", (Object)id);
        return this;
    }

    public DirectDebitParameters withDirectDebitType(DirectDebitType type) {
        this.origin.put("directDebitType", (Object)type);
        return this;
    }

    public DirectDebitParameters withSequenceType(SequenceType type) {
        this.origin.put("sequenceType", (Object)type);
        return this;
    }

    public DirectDebitParameters withExecutionDate(OffsetDateTime executionDate) {
        this.origin.put("executionDate", (Object)new StringOf(executionDate));
        return this;
    }

    public DirectDebitParameters asSingleBooking() {
        this.origin.put("singleBooking", true);
        return this;
    }

    public DirectDebitParameters withDebtors(Debtor ... debtors) {
        for (Debtor debtor : debtors) {
            this.origin.append("directDebits", (Object)debtor.asJson());
        }
        return this;
    }

    @Override
    public JSONObject asJson() {
        return this.origin;
    }

    public static final class Debtor
    implements Jsonable {
        private final JSONObject origin;

        public Debtor() {
            this(new JSONObject());
        }

        public Debtor(JSONObject origin) {
            this.origin = origin;
        }

        public Debtor withName(String name) {
            this.origin.put("debitorName", (Object)name);
            return this;
        }

        public Debtor withIban(String iban) {
            this.origin.put("debitorIban", (Object)iban);
            return this;
        }

        public Debtor withBic(String bic) {
            this.origin.put("debitorBic", (Object)bic);
            return this;
        }

        public Debtor withAmount(BigDecimal amount) {
            this.origin.put("amount", (Object)amount);
            return this;
        }

        public Debtor withPurpose(String purpose) {
            this.origin.put("purpose", (Object)purpose);
            return this;
        }

        public Debtor withSepaPurposeCode(String sepaPurposeCode) {
            this.origin.put("sepaPurposeCode", (Object)sepaPurposeCode);
            return this;
        }

        public Debtor withMandateId(String mandateId) {
            this.origin.put("mandateId", (Object)mandateId);
            return this;
        }

        public Debtor withMandateDate(OffsetDateTime mandateDate) {
            this.origin.put("mandateDate", (Object)new StringOf(mandateDate));
            return this;
        }

        public Debtor withCreditorId(String creditorId) {
            this.origin.put("creditorId", (Object)creditorId);
            return this;
        }

        public Debtor withEndToEndId(String endToEndId) {
            this.origin.put("endToEndIdId", (Object)endToEndId);
            return this;
        }

        @Override
        public JSONObject asJson() {
            return this.origin;
        }
    }

    public static enum SequenceType {
        OOFF,
        FRST,
        RCUR,
        FNAL;

    }

    public static enum DirectDebitType {
        BASIC,
        B2B;

    }
}

