/*
 * Decompiled with CFR 0.152.
 */
package org.proshin.finapi.bankconnection;

import java.util.Optional;
import org.apache.http.NameValuePair;
import org.json.JSONObject;
import org.proshin.finapi.accesstoken.AccessToken;
import org.proshin.finapi.account.Accounts;
import org.proshin.finapi.bank.Bank;
import org.proshin.finapi.bank.FpBank;
import org.proshin.finapi.bankconnection.BankConnection;
import org.proshin.finapi.bankconnection.in.FpEditParameters;
import org.proshin.finapi.bankconnection.out.Credentials;
import org.proshin.finapi.bankconnection.out.FpCredentials;
import org.proshin.finapi.bankconnection.out.FpStatus;
import org.proshin.finapi.bankconnection.out.FpTwoStepProcedures;
import org.proshin.finapi.bankconnection.out.FpUpdateResult;
import org.proshin.finapi.bankconnection.out.Owner;
import org.proshin.finapi.bankconnection.out.Status;
import org.proshin.finapi.bankconnection.out.TwoStepProcedures;
import org.proshin.finapi.bankconnection.out.Type;
import org.proshin.finapi.bankconnection.out.UpdateResult;
import org.proshin.finapi.endpoint.Endpoint;
import org.proshin.finapi.primitives.optional.OptionalObjectOf;
import org.proshin.finapi.primitives.optional.OptionalOf;
import org.proshin.finapi.primitives.optional.OptionalStringOf;

public final class FpBankConnection
implements BankConnection {
    private final Endpoint endpoint;
    private final AccessToken token;
    private final JSONObject origin;

    public FpBankConnection(Endpoint endpoint, AccessToken token, JSONObject origin) {
        this.endpoint = endpoint;
        this.token = token;
        this.origin = origin;
    }

    @Override
    public Long id() {
        return this.origin.getLong("id");
    }

    @Override
    public Bank bank() {
        return new FpBank(this.origin.getJSONObject("bank"));
    }

    @Override
    public Optional<String> name() {
        return new OptionalStringOf(this.origin, "name").get();
    }

    @Override
    public Credentials credentials() {
        return new FpCredentials(this.origin);
    }

    @Override
    public Type type() {
        return Type.valueOf(this.origin.getString("type"));
    }

    @Override
    public Status status() {
        return new FpStatus(this.origin);
    }

    @Override
    public Optional<UpdateResult> lastManualUpdate() {
        return ((Optional)new OptionalObjectOf(this.origin, "lastManualUpdate").get()).map(FpUpdateResult::new);
    }

    @Override
    public Optional<UpdateResult> lastAutoUpdate() {
        return ((Optional)new OptionalObjectOf(this.origin, "lastAutoUpdate").get()).map(FpUpdateResult::new);
    }

    @Override
    public Optional<TwoStepProcedures> twoStepProcedures() {
        return new OptionalOf<TwoStepProcedures>(this.origin, "twoStepProcedures", (jsonObject, key) -> new FpTwoStepProcedures((JSONObject)jsonObject)).get();
    }

    @Override
    public Accounts accounts() {
        throw new UnsupportedOperationException("This method is not implemented yet");
    }

    @Override
    public Iterable<Owner> owners() {
        throw new UnsupportedOperationException("This method is not implemented yet");
    }

    @Override
    public BankConnection edit(FpEditParameters parameters) {
        return new FpBankConnection(this.endpoint, this.token, new JSONObject(this.endpoint.patch(String.format("/api/v1/bankConnections/%d", this.id()), this.token, parameters)));
    }

    @Override
    public void delete() {
        this.endpoint.delete(String.format("/api/v1/bankConnections/%d", this.id()), this.token, new NameValuePair[0]);
    }
}

