/*
 * Decompiled with CFR 0.152.
 */
package org.proshin.finapi.bankconnection.in;

import java.util.Collection;
import org.cactoos.collection.StickyCollection;
import org.json.JSONObject;
import org.proshin.finapi.Jsonable;
import org.proshin.finapi.account.Type;

public final class ImportParameters
implements Jsonable {
    private final JSONObject origin;

    public ImportParameters() {
        this(new JSONObject());
    }

    public ImportParameters(JSONObject origin) {
        this.origin = origin;
    }

    public ImportParameters withBank(Long bankId) {
        this.origin.put("bankId", (Object)bankId);
        return this;
    }

    public ImportParameters withUserId(String userId) {
        this.origin.put("bankingUserId", (Object)userId);
        return this;
    }

    public ImportParameters withCustomerId(String customerId) {
        this.origin.put("bankingCustomerId", (Object)customerId);
        return this;
    }

    public ImportParameters withPin(String pin) {
        this.origin.put("bankingPin", (Object)pin);
        return this;
    }

    public ImportParameters withStorePin() {
        this.origin.put("storePin", true);
        return this;
    }

    public ImportParameters withName(String name) {
        this.origin.put("name", (Object)name);
        return this;
    }

    public ImportParameters withSkipPositionsDownload() {
        this.origin.put("skipPositionsDownload", true);
        return this;
    }

    public ImportParameters withLoadOwnerData() {
        this.origin.put("loadOwnerData", true);
        return this;
    }

    public ImportParameters withMaxDaysForDownload(int days) {
        this.origin.put("maxDaysForDownload", days);
        return this;
    }

    public ImportParameters withAccountTypes(Iterable<Type> types) {
        this.origin.put("accountTypeIds", (Collection)new StickyCollection(types));
        return this;
    }

    public ImportParameters withChallengeResponse(String challengeResponse) {
        this.origin.put("challengeResponse", (Object)challengeResponse);
        return this;
    }

    @Override
    public JSONObject asJson() {
        return this.origin;
    }
}

