/*
 * Decompiled with CFR 0.152.
 */
package org.proshin.finapi.category.out;

import java.math.BigDecimal;
import java.util.Iterator;
import org.json.JSONObject;
import org.proshin.finapi.accesstoken.AccessToken;
import org.proshin.finapi.category.out.CashFlow;
import org.proshin.finapi.category.out.CashFlows;
import org.proshin.finapi.category.out.FpCashFlow;
import org.proshin.finapi.endpoint.Endpoint;
import org.proshin.finapi.primitives.IterableJsonArray;

public final class FpCashFlows
implements CashFlows {
    private final Endpoint endpoint;
    private final AccessToken token;
    private final JSONObject origin;

    public FpCashFlows(Endpoint endpoint, AccessToken token, JSONObject origin) {
        this.endpoint = endpoint;
        this.token = token;
        this.origin = origin;
    }

    @Override
    public BigDecimal income() {
        return this.origin.getBigDecimal("totalIncome");
    }

    @Override
    public BigDecimal spending() {
        return this.origin.getBigDecimal("totalSpending");
    }

    @Override
    public BigDecimal balance() {
        return this.origin.getBigDecimal("totalBalance");
    }

    @Override
    public Iterator<CashFlow> iterator() {
        return new IterableJsonArray<CashFlow>(this.origin.getJSONArray("cashFlows"), (array, index) -> new FpCashFlow(this.endpoint, this.token, array.getJSONObject(index.intValue()))).iterator();
    }
}

