/*
 * Decompiled with CFR 0.152.
 */
package org.proshin.finapi.exception;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.OffsetDateTime;
import java.util.Optional;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.cactoos.Input;
import org.cactoos.Scalar;
import org.cactoos.io.InputOf;
import org.cactoos.scalar.SolidScalar;
import org.cactoos.scalar.UncheckedScalar;
import org.cactoos.text.TextOf;
import org.json.JSONObject;
import org.proshin.finapi.exception.FinapiError;
import org.proshin.finapi.primitives.IterableJsonArray;
import org.proshin.finapi.primitives.OffsetDateTimeOf;

public final class FinapiException
extends RuntimeException {
    private static final long serialVersionUID = -5608855544688297953L;
    private final transient UncheckedScalar<JSONObject> origin;
    private final transient UncheckedScalar<Optional<String>> location;

    public FinapiException(int expected, HttpResponse response) {
        super(String.format("Unexpected response code: expected=%d, actual=%s", expected, response.getStatusLine().getStatusCode()));
        String content;
        try {
            content = new TextOf((Input)new InputOf(response.getEntity().getContent()), StandardCharsets.UTF_8).asString();
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't read the response body", e);
        }
        this.origin = new UncheckedScalar((Scalar)new SolidScalar(() -> new JSONObject(content)));
        Header header = response.getFirstHeader("Location");
        this.location = new UncheckedScalar(() -> Optional.ofNullable(header).map(NameValuePair::getValue));
    }

    public Iterable<FinapiError> errors() {
        return new IterableJsonArray<FinapiError>(((JSONObject)this.origin.value()).getJSONArray("errors"), (array, index) -> new FinapiError(array.getJSONObject(index.intValue())));
    }

    public OffsetDateTime date() {
        return new OffsetDateTimeOf(((JSONObject)this.origin.value()).getString("date")).get();
    }

    public String requestId() {
        return ((JSONObject)this.origin.value()).getString("requestId");
    }

    public String endpoint() {
        return ((JSONObject)this.origin.value()).getString("endpoint");
    }

    public String authContext() {
        return ((JSONObject)this.origin.value()).getString("authContext");
    }

    public String bank() {
        return ((JSONObject)this.origin.value()).getString("bank");
    }

    public Optional<String> location() {
        return (Optional)this.location.value();
    }
}

