/*
 * Decompiled with CFR 0.152.
 */
package org.proshin.finapi.mandator;

import java.time.OffsetDateTime;
import java.util.Locale;
import org.json.JSONObject;
import org.proshin.finapi.accesstoken.AccessToken;
import org.proshin.finapi.category.Category;
import org.proshin.finapi.category.FpCategory;
import org.proshin.finapi.endpoint.Endpoint;
import org.proshin.finapi.mandator.IbanRule;
import org.proshin.finapi.primitives.Direction;
import org.proshin.finapi.primitives.OffsetDateTimeOf;

public final class FpIbanRule
implements IbanRule {
    private final Endpoint endpoint;
    private final AccessToken token;
    private final JSONObject origin;

    public FpIbanRule(Endpoint endpoint, AccessToken token, JSONObject origin) {
        this.endpoint = endpoint;
        this.token = token;
        this.origin = origin;
    }

    @Override
    public Long id() {
        return this.origin.getLong("id");
    }

    @Override
    public Category category() {
        return new FpCategory(this.endpoint, this.token, this.origin.getJSONObject("category"));
    }

    @Override
    public Direction direction() {
        return Direction.valueOf(this.origin.getString("direction").toLowerCase(Locale.ENGLISH));
    }

    @Override
    public OffsetDateTime creationDate() {
        return new OffsetDateTimeOf(this.origin.getString("creationDate")).get();
    }

    @Override
    public String iban() {
        return this.origin.getString("iban");
    }
}

