/*
 * Decompiled with CFR 0.152.
 */
package org.proshin.finapi.mandator;

import org.json.JSONObject;
import org.proshin.finapi.accesstoken.AccessToken;
import org.proshin.finapi.endpoint.Endpoint;
import org.proshin.finapi.mandator.FpIbanRules;
import org.proshin.finapi.mandator.FpKeywordRules;
import org.proshin.finapi.mandator.IbanRules;
import org.proshin.finapi.mandator.KeywordRules;
import org.proshin.finapi.mandator.Mandator;
import org.proshin.finapi.mandator.in.UsersCriteria;
import org.proshin.finapi.mandator.out.DeletionResult;
import org.proshin.finapi.mandator.out.FpDeletionResult;
import org.proshin.finapi.mandator.out.FpUser;
import org.proshin.finapi.mandator.out.User;
import org.proshin.finapi.primitives.paging.FpPage;
import org.proshin.finapi.primitives.paging.Page;

public final class FpMandator
implements Mandator {
    private final Endpoint endpoint;
    private final AccessToken token;
    private final String url;

    public FpMandator(Endpoint endpoint, AccessToken token) {
        this(endpoint, token, "/api/v1/mandatorAdmin/");
    }

    public FpMandator(Endpoint endpoint, AccessToken token, String url) {
        this.endpoint = endpoint;
        this.token = token;
        this.url = url;
    }

    @Override
    public Page<User> users(UsersCriteria criteria) {
        return new FpPage<User>("users", new JSONObject(this.endpoint.get(this.url + "getUserList", this.token, criteria)), (array, index) -> new FpUser(array.getJSONObject(index.intValue())));
    }

    @Override
    public DeletionResult deleteUsers(Iterable<String> ids) {
        return new FpDeletionResult(new JSONObject(this.endpoint.post(this.url + "deleteUsers", this.token, () -> {
            JSONObject body = new JSONObject();
            for (String id : ids) {
                body.append("userIds", (Object)id);
            }
            return body;
        })));
    }

    @Override
    public void changeClientCredentials(String clientId, String oldClientSecret, String newClientSecret) {
        this.endpoint.post(this.url + "changeClientCredentials", this.token, () -> new JSONObject().append("clientId", (Object)clientId).append("oldClientSecret", (Object)oldClientSecret).append("newClientSecret", (Object)newClientSecret));
    }

    @Override
    public KeywordRules keywordRules() {
        return new FpKeywordRules(this.endpoint, this.token, this.url + "keywordRules/");
    }

    @Override
    public IbanRules ibanRules() {
        return new FpIbanRules(this.endpoint, this.token, this.url + "ibanRules/");
    }
}

