/*
 * Decompiled with CFR 0.152.
 */
package org.proshin.finapi.mandator.out;

import java.time.OffsetDateTime;
import java.util.Optional;
import org.json.JSONObject;
import org.proshin.finapi.mandator.out.FpMonthlyUserStats;
import org.proshin.finapi.mandator.out.MonthlyUserStats;
import org.proshin.finapi.mandator.out.User;
import org.proshin.finapi.primitives.IterableJsonArray;
import org.proshin.finapi.primitives.OffsetDateTimeOf;
import org.proshin.finapi.primitives.optional.OptionalOffsetDateTimeOf;

public final class FpUser
implements User {
    private final JSONObject origin;
    private final String pattern;

    public FpUser(JSONObject origin) {
        this.origin = origin;
        this.pattern = "YYYY-MM-DD";
    }

    @Override
    public String id() {
        return this.origin.getString("id");
    }

    @Override
    public OffsetDateTime registrationDate() {
        return new OffsetDateTimeOf(this.origin.getString("registrationDate"), this.pattern).get();
    }

    @Override
    public Optional<OffsetDateTime> deletionDate() {
        return new OptionalOffsetDateTimeOf(this.origin, "deletionDate", this.pattern).get();
    }

    @Override
    public Optional<OffsetDateTime> lastActiveDate() {
        return new OptionalOffsetDateTimeOf(this.origin, "lastActiveDate", this.pattern).get();
    }

    @Override
    public int bankConnectionCount() {
        return this.origin.getInt("bankConnectionCount");
    }

    @Override
    public Optional<OffsetDateTime> latestBankConnectionImportDate() {
        return new OptionalOffsetDateTimeOf(this.origin, "latestBankConnectionImportDate", this.pattern).get();
    }

    @Override
    public Optional<OffsetDateTime> latestBankConnectionDeletionDate() {
        return new OptionalOffsetDateTimeOf(this.origin, "latestBankConnectionDeletionDate", this.pattern).get();
    }

    @Override
    public Iterable<MonthlyUserStats> monthlyUserStats() {
        return new IterableJsonArray<MonthlyUserStats>(this.origin.getJSONArray("monthlyStats"), (array, index) -> new FpMonthlyUserStats(array.getJSONObject(index.intValue())));
    }
}

