/*
 * Decompiled with CFR 0.152.
 */
package org.proshin.finapi.payment.in;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.http.NameValuePair;
import org.proshin.finapi.primitives.StringOf;
import org.proshin.finapi.primitives.pair.CommaSeparatedPair;
import org.proshin.finapi.primitives.pair.UrlEncodedPair;

public class FpQueryCriteria
implements Iterable<NameValuePair> {
    private final List<NameValuePair> pairs;

    public FpQueryCriteria() {
        this(new ArrayList<NameValuePair>());
    }

    public FpQueryCriteria(List<NameValuePair> pairs) {
        this.pairs = pairs;
    }

    public FpQueryCriteria withIds(Iterable<Long> ids) {
        this.pairs.add(new UrlEncodedPair(new CommaSeparatedPair<Long>("ids", ids)));
        return this;
    }

    public FpQueryCriteria withAccountIds(Iterable<Long> accountIds) {
        this.pairs.add(new UrlEncodedPair(new CommaSeparatedPair<Long>("accountIds", accountIds)));
        return this;
    }

    public FpQueryCriteria withMinAmount(BigDecimal minAmount) {
        this.pairs.add(new UrlEncodedPair("minAmount", new StringOf(minAmount)));
        return this;
    }

    public FpQueryCriteria withMaxAmount(BigDecimal maxAmount) {
        this.pairs.add(new UrlEncodedPair("maxAmount", new StringOf(maxAmount)));
        return this;
    }

    public FpQueryCriteria withPage(int page, int perPage) {
        this.pairs.add(new UrlEncodedPair("page", page));
        this.pairs.add(new UrlEncodedPair("perPage", perPage));
        return this;
    }

    public FpQueryCriteria orderBy(String ... orders) {
        for (String order : orders) {
            this.pairs.add(new UrlEncodedPair("order", order));
        }
        return this;
    }

    @Override
    public Iterator<NameValuePair> iterator() {
        return this.pairs.iterator();
    }
}

