/*
 * Decompiled with CFR 0.152.
 */
package org.proshin.finapi.account.in;

import java.math.BigDecimal;
import java.time.LocalDate;
import org.cactoos.iterator.IteratorOf;
import org.json.JSONObject;
import org.proshin.finapi.Jsonable;
import org.proshin.finapi.primitives.StringOf;

public final class MoneyTransferParameters
implements Jsonable {
    private final JSONObject origin;

    public MoneyTransferParameters() {
        this(new JSONObject());
    }

    public MoneyTransferParameters(JSONObject origin) {
        this.origin = origin;
    }

    public MoneyTransferParameters withAccount(Long account) {
        this.origin.put("accountId", (Object)account);
        return this;
    }

    public MoneyTransferParameters withBankingPin(String bankingPin) {
        this.origin.put("bankingPin", (Object)bankingPin);
        return this;
    }

    public MoneyTransferParameters withStoringPin() {
        this.origin.put("storePin", true);
        return this;
    }

    public MoneyTransferParameters withTwoStepProcedure(String id) {
        this.origin.put("twoStepProcedureId", (Object)id);
        return this;
    }

    public MoneyTransferParameters withChallengeResponse(String response) {
        this.origin.put("challengeResponse", (Object)response);
        return this;
    }

    public MoneyTransferParameters withExecutionDate(LocalDate executionDate) {
        this.origin.put("executionDate", (Object)new StringOf(executionDate));
        return this;
    }

    public MoneyTransferParameters asSingleBooking() {
        this.origin.put("singleBooking", true);
        return this;
    }

    public MoneyTransferParameters withRecipients(Recipient ... recipients) {
        IteratorOf iterator = new IteratorOf((Object[])recipients);
        if (iterator.hasNext()) {
            JSONObject jsonObject = ((Recipient)iterator.next()).asJson();
            for (String key : jsonObject.keySet()) {
                this.origin.put(key, jsonObject.get(key));
            }
        }
        while (iterator.hasNext()) {
            this.origin.append("additionalMoneyTransfers", (Object)((Recipient)iterator.next()).asJson());
        }
        return this;
    }

    @Override
    public JSONObject asJson() {
        return this.origin;
    }

    public static final class Recipient
    implements Jsonable {
        private final JSONObject origin;

        public Recipient() {
            this(new JSONObject());
        }

        public Recipient(JSONObject origin) {
            this.origin = origin;
        }

        public Recipient withName(String name) {
            this.origin.put("recipientName", (Object)name);
            return this;
        }

        public Recipient withIban(String iban) {
            this.origin.put("recipientIban", (Object)iban);
            return this;
        }

        public Recipient withBic(String bic) {
            this.origin.put("recipientBic", (Object)bic);
            return this;
        }

        public Recipient withClearingAccount(String id) {
            this.origin.put("clearingAccountId", (Object)id);
            return this;
        }

        public Recipient withAmount(BigDecimal amount) {
            this.origin.put("amount", (Object)amount);
            return this;
        }

        public Recipient withPurpose(String purpose) {
            this.origin.put("purpose", (Object)purpose);
            return this;
        }

        public Recipient withSepaPurposeCode(String sepaPurposeCode) {
            this.origin.put("sepaPurposeCode", (Object)sepaPurposeCode);
            return this;
        }

        @Override
        public JSONObject asJson() {
            return this.origin;
        }
    }
}

