/*
 * Decompiled with CFR 0.152.
 */
package org.proshin.finapi.bank;

import java.time.OffsetDateTime;
import java.util.Optional;
import org.json.JSONObject;
import org.proshin.finapi.bank.Bank;
import org.proshin.finapi.bank.out.FpLoginFields;
import org.proshin.finapi.bank.out.LoginFields;
import org.proshin.finapi.primitives.IterableJsonArray;
import org.proshin.finapi.primitives.optional.OptionalOffsetDateTimeOf;
import org.proshin.finapi.primitives.optional.OptionalStringOf;

public final class FpBank
implements Bank {
    private final JSONObject origin;

    public FpBank(JSONObject origin) {
        this.origin = origin;
    }

    @Override
    public Long id() {
        return this.origin.getLong("id");
    }

    @Override
    public String name() {
        return this.origin.getString("name");
    }

    @Override
    public Optional<String> loginHint() {
        return new OptionalStringOf(this.origin, "loginHint").get();
    }

    @Override
    public Optional<String> bic() {
        return new OptionalStringOf(this.origin, "bic").get();
    }

    @Override
    public String blz() {
        return this.origin.getString("blz");
    }

    @Override
    public LoginFields loginFields() {
        return new FpLoginFields(this.origin);
    }

    @Override
    public boolean isCustomerIdPassword() {
        return this.origin.getBoolean("isCustomerIdPassword");
    }

    @Override
    public boolean isSupported() {
        return this.origin.getBoolean("isSupported");
    }

    @Override
    public Iterable<Bank.DataSource> supportedDataSources() {
        return new IterableJsonArray<Bank.DataSource>(this.origin.getJSONArray("supportedDataSources"), (array, index) -> Bank.DataSource.valueOf(array.getString(index.intValue())));
    }

    @Override
    public boolean pinsAreVolatile() {
        return this.origin.getBoolean("pinsAreVolatile");
    }

    @Override
    public Optional<String> location() {
        return new OptionalStringOf(this.origin, "location").get();
    }

    @Override
    public Optional<String> city() {
        return new OptionalStringOf(this.origin, "city").get();
    }

    @Override
    public boolean isTestBank() {
        return this.origin.getBoolean("isTestBank");
    }

    @Override
    public int popularity() {
        return this.origin.getInt("popularity");
    }

    @Override
    public int health() {
        return this.origin.getInt("health");
    }

    @Override
    public Optional<OffsetDateTime> lastCommunicationAttempt() {
        return new OptionalOffsetDateTimeOf(this.origin, "lastCommunicationAttempt").get();
    }

    @Override
    public Optional<OffsetDateTime> lastSuccessfulCommunication() {
        return new OptionalOffsetDateTimeOf(this.origin, "lastSuccessfulCommunication").get();
    }
}

