/*
 * Decompiled with CFR 0.152.
 */
package org.proshin.finapi.category;

import org.apache.http.NameValuePair;
import org.json.JSONArray;
import org.json.JSONObject;
import org.proshin.finapi.accesstoken.AccessToken;
import org.proshin.finapi.category.Categories;
import org.proshin.finapi.category.Category;
import org.proshin.finapi.category.FpCategory;
import org.proshin.finapi.category.in.CashFlowsCriteria;
import org.proshin.finapi.category.in.CategoriesCriteria;
import org.proshin.finapi.category.in.CreateCategoryParameters;
import org.proshin.finapi.category.in.TrainCategorizationParameters;
import org.proshin.finapi.category.out.CashFlows;
import org.proshin.finapi.category.out.FpCashFlows;
import org.proshin.finapi.endpoint.Endpoint;
import org.proshin.finapi.primitives.IterableJsonArray;
import org.proshin.finapi.primitives.paging.FpPage;
import org.proshin.finapi.primitives.paging.Page;

public final class FpCategories
implements Categories {
    private final Endpoint endpoint;
    private final AccessToken token;
    private final String url;

    public FpCategories(Endpoint endpoint, AccessToken token) {
        this(endpoint, token, "/api/v1/categories/");
    }

    public FpCategories(Endpoint endpoint, AccessToken token, String url) {
        this.endpoint = endpoint;
        this.token = token;
        this.url = url;
    }

    @Override
    public Category one(Long id) {
        return new FpCategory(this.endpoint, this.token, new JSONObject(this.endpoint.get(this.url + id, this.token, new NameValuePair[0])));
    }

    @Override
    public Page<Category> query(CategoriesCriteria criteria) {
        return new FpPage<Category>("categories", new JSONObject(this.endpoint.get(this.url, this.token, criteria)), (array, index) -> new FpCategory(this.endpoint, this.token, array.getJSONObject(index.intValue())));
    }

    @Override
    public CashFlows cashFlows(CashFlowsCriteria criteria) {
        return new FpCashFlows(this.endpoint, this.token, new JSONObject(this.endpoint.get(this.url + "cashFlows", this.token, criteria)));
    }

    @Override
    public Category create(CreateCategoryParameters parameters) {
        return new FpCategory(this.endpoint, this.token, new JSONObject(this.endpoint.post(this.url, this.token, parameters, 201)));
    }

    @Override
    public void trainCategorization(TrainCategorizationParameters parameters) {
        this.endpoint.post(this.url + "trainCategorization", this.token, parameters);
    }

    @Override
    public Iterable<Long> deleteAll() {
        return new IterableJsonArray<Long>(new JSONObject(this.endpoint.delete(this.url, this.token, new NameValuePair[0])).getJSONArray("identifiers"), JSONArray::getLong);
    }
}

