/*
 * Decompiled with CFR 0.152.
 */
package org.proshin.finapi.mandator.out;

import java.time.LocalDate;
import java.util.Optional;
import org.json.JSONObject;
import org.proshin.finapi.mandator.out.FpMonthlyUserStats;
import org.proshin.finapi.mandator.out.MonthlyUserStats;
import org.proshin.finapi.mandator.out.User;
import org.proshin.finapi.primitives.IterableJsonArray;
import org.proshin.finapi.primitives.LocalDateOf;
import org.proshin.finapi.primitives.optional.OptionalLocalDateOf;

public final class FpUser
implements User {
    private final JSONObject origin;

    public FpUser(JSONObject origin) {
        this.origin = origin;
    }

    @Override
    public String id() {
        return this.origin.getString("userId");
    }

    @Override
    public LocalDate registrationDate() {
        return new LocalDateOf(this.origin.getString("registrationDate")).get();
    }

    @Override
    public Optional<LocalDate> deletionDate() {
        return new OptionalLocalDateOf(this.origin, "deletionDate").get();
    }

    @Override
    public Optional<LocalDate> lastActiveDate() {
        return new OptionalLocalDateOf(this.origin, "lastActiveDate").get();
    }

    @Override
    public int bankConnectionCount() {
        return this.origin.getInt("bankConnectionCount");
    }

    @Override
    public Optional<LocalDate> latestBankConnectionImportDate() {
        return new OptionalLocalDateOf(this.origin, "latestBankConnectionImportDate").get();
    }

    @Override
    public Optional<LocalDate> latestBankConnectionDeletionDate() {
        return new OptionalLocalDateOf(this.origin, "latestBankConnectionDeletionDate").get();
    }

    @Override
    public Iterable<MonthlyUserStats> monthlyUserStats() {
        return new IterableJsonArray<MonthlyUserStats>(this.origin.getJSONArray("monthlyStats"), (array, index) -> new FpMonthlyUserStats(array.getJSONObject(index.intValue())));
    }

    @Override
    public boolean isLocked() {
        return this.origin.getBoolean("isLocked");
    }
}

