/*
 * Decompiled with CFR 0.152.
 */
package org.proshin.finapi.primitives;

import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.function.Supplier;

public final class OffsetDateTimeOf
implements Supplier<OffsetDateTime> {
    private final String origin;
    private final DateTimeFormatter formatter;

    public OffsetDateTimeOf(String origin) {
        this(origin, "yyyy-MM-dd HH:mm:ss.SSS");
    }

    public OffsetDateTimeOf(String origin, String pattern) {
        this(origin, DateTimeFormatter.ofPattern(pattern).withZone(ZoneId.of("Europe/Berlin")));
    }

    public OffsetDateTimeOf(String origin, DateTimeFormatter formatter) {
        this.origin = origin;
        this.formatter = formatter;
    }

    @Override
    public OffsetDateTime get() {
        return ZonedDateTime.parse(this.origin, this.formatter).toOffsetDateTime();
    }
}

