/*
 * Decompiled with CFR 0.152.
 */
package org.proshin.finapi.security;

import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.util.Optional;
import org.json.JSONObject;
import org.proshin.finapi.primitives.optional.OptionalBigDecimalOf;
import org.proshin.finapi.primitives.optional.OptionalOffsetDateTimeOf;
import org.proshin.finapi.primitives.optional.OptionalStringOf;
import org.proshin.finapi.security.Security;
import org.proshin.finapi.security.out.QuantityNominalType;
import org.proshin.finapi.security.out.QuoteType;

public final class FpSecurity
implements Security {
    private final JSONObject origin;

    public FpSecurity(JSONObject origin) {
        this.origin = origin;
    }

    @Override
    public Long id() {
        return this.origin.getLong("id");
    }

    @Override
    public Long account() {
        return this.origin.getLong("accountId");
    }

    @Override
    public Optional<String> name() {
        return new OptionalStringOf(this.origin, "name").get();
    }

    @Override
    public Optional<String> isin() {
        return new OptionalStringOf(this.origin, "isin").get();
    }

    @Override
    public Optional<String> wkn() {
        return new OptionalStringOf(this.origin, "wkn").get();
    }

    @Override
    public Optional<BigDecimal> quote() {
        return new OptionalBigDecimalOf(this.origin, "quote").get();
    }

    @Override
    public Optional<String> quoteCurrency() {
        return new OptionalStringOf(this.origin, "quoteCurrency").get();
    }

    @Override
    public Optional<QuoteType> quoteType() {
        return ((Optional)new OptionalStringOf(this.origin, "quoteType").get()).map(QuoteType::valueOf);
    }

    @Override
    public Optional<OffsetDateTime> quoteDate() {
        return new OptionalOffsetDateTimeOf(this.origin, "quoteDate").get();
    }

    @Override
    public Optional<BigDecimal> quantityNominal() {
        return new OptionalBigDecimalOf(this.origin, "quantityNominal").get();
    }

    @Override
    public Optional<QuantityNominalType> quantityNominalType() {
        return ((Optional)new OptionalStringOf(this.origin, "quantityNominalType").get()).map(QuantityNominalType::valueOf);
    }

    @Override
    public Optional<BigDecimal> marketValue() {
        return new OptionalBigDecimalOf(this.origin, "marketValue").get();
    }

    @Override
    public Optional<String> marketValueCurrency() {
        return new OptionalStringOf(this.origin, "marketValueCurrency").get();
    }

    @Override
    public Optional<BigDecimal> entryQuote() {
        return new OptionalBigDecimalOf(this.origin, "entryQuote").get();
    }

    @Override
    public Optional<String> entryQuoteCurrency() {
        return new OptionalStringOf(this.origin, "entryQuoteCurrency").get();
    }

    @Override
    public Optional<BigDecimal> profitOrLoss() {
        return new OptionalBigDecimalOf(this.origin, "profitOrLoss").get();
    }
}

