/*
 * Decompiled with CFR 0.152.
 */
package org.proshin.finapi.transaction.in;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.http.NameValuePair;
import org.proshin.finapi.primitives.Direction;
import org.proshin.finapi.primitives.StringOf;
import org.proshin.finapi.primitives.pair.CommaSeparatedPair;
import org.proshin.finapi.primitives.pair.UrlEncodedPair;

public final class TransactionsCriteria
implements Iterable<NameValuePair> {
    private final List<NameValuePair> pairs;

    public TransactionsCriteria() {
        this(new ArrayList<NameValuePair>());
    }

    public TransactionsCriteria(List<NameValuePair> pairs) {
        this.pairs = pairs;
    }

    public TransactionsCriteria withIds(Iterable<Long> ids) {
        this.pairs.add(new UrlEncodedPair(new CommaSeparatedPair<Long>("ids", ids)));
        return this;
    }

    public TransactionsCriteria withView(View view) {
        this.pairs.add(new UrlEncodedPair("view", view.label()));
        return this;
    }

    public TransactionsCriteria withSearch(String search) {
        this.pairs.add(new UrlEncodedPair("search", search));
        return this;
    }

    public TransactionsCriteria withCounterpart(String counterpart) {
        this.pairs.add(new UrlEncodedPair("counterpart", counterpart));
        return this;
    }

    public TransactionsCriteria withPurpose(String purpose) {
        this.pairs.add(new UrlEncodedPair("purpose", purpose));
        return this;
    }

    public TransactionsCriteria withAccounts(Iterable<Long> accounts) {
        this.pairs.add(new UrlEncodedPair(new CommaSeparatedPair<Long>("accountIds", accounts)));
        return this;
    }

    public TransactionsCriteria withMinBankBookingDate(LocalDate minBankBookingDate) {
        this.pairs.add(new UrlEncodedPair("minBankBookingDate", new StringOf(minBankBookingDate)));
        return this;
    }

    public TransactionsCriteria withMaxBankBookingDate(LocalDate maxBankBookingDate) {
        this.pairs.add(new UrlEncodedPair("maxBankBookingDate", new StringOf(maxBankBookingDate)));
        return this;
    }

    public TransactionsCriteria withMinFinapiBookingDate(LocalDate minFinapiBookingDate) {
        this.pairs.add(new UrlEncodedPair("minFinapiBookingDate", new StringOf(minFinapiBookingDate)));
        return this;
    }

    public TransactionsCriteria withMaxFinapiBookingDate(LocalDate maxFinapiBookingDate) {
        this.pairs.add(new UrlEncodedPair("maxFinapiBookingDate", new StringOf(maxFinapiBookingDate)));
        return this;
    }

    public TransactionsCriteria withMinAmount(BigDecimal minAmount) {
        this.pairs.add(new UrlEncodedPair("minAmount", new StringOf(minAmount)));
        return this;
    }

    public TransactionsCriteria withMaxAmount(BigDecimal maxAmount) {
        this.pairs.add(new UrlEncodedPair("maxAmount", new StringOf(maxAmount)));
        return this;
    }

    public TransactionsCriteria withDirection(Direction direction) {
        this.pairs.add(new UrlEncodedPair("direction", direction.lowerCase()));
        return this;
    }

    public TransactionsCriteria withLabels(Iterable<Long> labels) {
        this.pairs.add(new UrlEncodedPair(new CommaSeparatedPair<Long>("labelIds", labels)));
        return this;
    }

    public TransactionsCriteria withCategories(Iterable<Long> categories) {
        this.pairs.add(new UrlEncodedPair(new CommaSeparatedPair<Long>("categoryIds", categories)));
        return this;
    }

    public TransactionsCriteria withoutIncludingChildCategories() {
        this.pairs.add(new UrlEncodedPair("includeChildCategories", false));
        return this;
    }

    public TransactionsCriteria withIsNew(boolean isNew) {
        this.pairs.add(new UrlEncodedPair("isNew", isNew));
        return this;
    }

    public TransactionsCriteria withIsPotentialDuplicate(boolean isPotentialDuplicate) {
        this.pairs.add(new UrlEncodedPair("isPotentialDuplicate", isPotentialDuplicate));
        return this;
    }

    public TransactionsCriteria withIsAdjustingEntry(boolean isAdjustingEntry) {
        this.pairs.add(new UrlEncodedPair("isAdjustingEntry", isAdjustingEntry));
        return this;
    }

    public TransactionsCriteria withMinImportDate(LocalDate minImportDate) {
        this.pairs.add(new UrlEncodedPair("minImportDate", new StringOf(minImportDate)));
        return this;
    }

    public TransactionsCriteria withMaxImportDate(LocalDate maxImportDate) {
        this.pairs.add(new UrlEncodedPair("maxImportDate", new StringOf(maxImportDate)));
        return this;
    }

    public TransactionsCriteria withPage(int page, int perPage) {
        this.pairs.add(new UrlEncodedPair("page", page));
        this.pairs.add(new UrlEncodedPair("perPage", perPage));
        return this;
    }

    public TransactionsCriteria orderBy(String ... orders) {
        for (String order : orders) {
            this.pairs.add(new UrlEncodedPair("order", order));
        }
        return this;
    }

    @Override
    public Iterator<NameValuePair> iterator() {
        return this.pairs.iterator();
    }

    public static enum View {
        BANK("bankView"),
        USER("userView");

        private final String label;

        private View(String label) {
            this.label = label;
        }

        public final String label() {
            return this.label;
        }
    }
}

