/*
 * Decompiled with CFR 0.152.
 */
package org.proshin.finapi.user;

import org.apache.http.NameValuePair;
import org.cactoos.iterable.IterableOf;
import org.json.JSONObject;
import org.proshin.finapi.accesstoken.AccessToken;
import org.proshin.finapi.endpoint.Endpoint;
import org.proshin.finapi.primitives.pair.UrlEncodedPair;
import org.proshin.finapi.user.FpUser;
import org.proshin.finapi.user.User;
import org.proshin.finapi.user.Users;
import org.proshin.finapi.user.in.FpCreateParameters;

public final class FpUsers
implements Users {
    private final Endpoint endpoint;
    private final AccessToken token;
    private final String url;

    public FpUsers(Endpoint endpoint, AccessToken token) {
        this(endpoint, token, "/api/v1/users/");
    }

    public FpUsers(Endpoint endpoint, AccessToken token, String url) {
        this.endpoint = endpoint;
        this.token = token;
        this.url = url;
    }

    @Override
    public User authorized() {
        return new FpUser(new JSONObject(this.endpoint.get(this.url, this.token, new NameValuePair[0])));
    }

    @Override
    public boolean verified(String userId) {
        return new JSONObject(this.endpoint.get(this.url + "verificationStatus", this.token, (Iterable<NameValuePair>)new IterableOf((Object[])new NameValuePair[]{new UrlEncodedPair("userId", userId)}))).getBoolean("isUserVerified");
    }

    @Override
    public User create(FpCreateParameters parameters) {
        return new FpUser(new JSONObject(this.endpoint.post(this.url, this.token, parameters, 201)));
    }

    @Override
    public String requestPasswordChange(String userId) {
        return new JSONObject(this.endpoint.post(this.url + "requestPasswordChange", this.token, () -> new JSONObject().put("userId", (Object)userId))).getString("passwordChangeToken");
    }

    @Override
    public void executePasswordChange(String userId, String password, String token) {
        this.endpoint.post(this.url + "executePasswordChange", this.token, () -> new JSONObject().put("userId", (Object)userId).put("password", (Object)password).put("passwordChangeToken", (Object)token));
    }

    @Override
    public void verify(String userId) {
        this.endpoint.post(this.url + "verify/" + userId, this.token, 200);
    }

    @Override
    public void deleteUnverified(String userId) {
        this.endpoint.delete(this.url + userId, this.token, new NameValuePair[0]);
    }
}

