/*
 * Decompiled with CFR 0.152.
 */
package org.proshin.finapi.accesstoken;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicNameValuePair;
import org.json.JSONObject;
import org.proshin.finapi.accesstoken.AccessToken;
import org.proshin.finapi.accesstoken.AccessTokens;
import org.proshin.finapi.accesstoken.ClientAccessToken;
import org.proshin.finapi.accesstoken.UserAccessToken;
import org.proshin.finapi.endpoint.Endpoint;
import org.proshin.finapi.primitives.QueryString;
import org.proshin.finapi.primitives.pair.UrlEncodedPair;

public final class FpAccessTokens
implements AccessTokens {
    private final Endpoint endpoint;
    private final String tokenUrl;
    private final String revokeUrl;

    public FpAccessTokens(Endpoint endpoint) {
        this(endpoint, "/oauth/token", "/oauth/revoke");
    }

    public FpAccessTokens(Endpoint endpoint, String tokenUrl, String revokeUrl) {
        this.endpoint = endpoint;
        this.tokenUrl = tokenUrl;
        this.revokeUrl = revokeUrl;
    }

    @Override
    public AccessToken clientToken(String clientId, String clientSecret) {
        return new ClientAccessToken(new JSONObject(this.endpoint.post(this.tokenUrl + '?' + new QueryString(new UrlEncodedPair("grant_type", "client_credentials"), new UrlEncodedPair("client_id", clientId), new UrlEncodedPair("client_secret", clientSecret)).get(), (HttpEntity)new StringEntity("", ContentType.create((String)"application/json", (Charset)StandardCharsets.UTF_8)), 200)));
    }

    @Override
    public AccessToken userToken(String clientId, String clientSecret, String username, String password) {
        return new UserAccessToken(new JSONObject(this.endpoint.post(this.tokenUrl + '?' + new QueryString(new UrlEncodedPair("grant_type", "password"), new UrlEncodedPair("client_id", clientId), new UrlEncodedPair("client_secret", clientSecret), new UrlEncodedPair("username", username), new UrlEncodedPair("password", password)).get(), (HttpEntity)new StringEntity("", ContentType.create((String)"application/json", (Charset)StandardCharsets.UTF_8)), 200)));
    }

    @Override
    public AccessToken userToken(String clientId, String clientSecret, String refreshToken) {
        return new UserAccessToken(new JSONObject(this.endpoint.post(this.tokenUrl + '?' + new QueryString(new UrlEncodedPair("grant_type", "refresh_token"), new UrlEncodedPair("client_id", clientId), new UrlEncodedPair("client_secret", clientSecret), new UrlEncodedPair("refresh_token", refreshToken)).get(), (HttpEntity)new StringEntity("", ContentType.create((String)"application/json", (Charset)StandardCharsets.UTF_8)), 200)));
    }

    @Override
    public void revoke(AccessToken clientToken, AccessToken userToken, AccessTokens.RevokeToken tokensToRevoke) {
        ArrayList<Object> parameters = new ArrayList<Object>();
        parameters.add(new BasicNameValuePair("token", userToken.accessToken()));
        switch (tokensToRevoke) {
            case ACCESS_TOKEN_ONLY: {
                parameters.add(new UrlEncodedPair("token_type_hint", "access_token"));
                break;
            }
            case REFRESH_TOKEN_ONLY: {
                parameters.add(new UrlEncodedPair("token_type_hint", "refresh_token"));
                break;
            }
        }
        this.endpoint.post(this.revokeUrl + '?' + new QueryString(parameters).get(), clientToken, (HttpEntity)new StringEntity("", ContentType.create((String)"application/json", (Charset)StandardCharsets.UTF_8)), 200);
    }
}

