/*
 * Decompiled with CFR 0.152.
 */
package org.proshin.finapi.category;

import java.util.Optional;
import org.apache.http.NameValuePair;
import org.json.JSONArray;
import org.json.JSONObject;
import org.proshin.finapi.accesstoken.AccessToken;
import org.proshin.finapi.category.Category;
import org.proshin.finapi.category.in.FpEditParameters;
import org.proshin.finapi.endpoint.Endpoint;
import org.proshin.finapi.primitives.IterableJsonArray;
import org.proshin.finapi.primitives.optional.OptionalLongOf;
import org.proshin.finapi.primitives.optional.OptionalStringOf;

public final class FpCategory
implements Category {
    private final Endpoint endpoint;
    private final AccessToken token;
    private final JSONObject origin;
    private final String url;

    public FpCategory(Endpoint endpoint, AccessToken token, JSONObject origin, String url) {
        this.endpoint = endpoint;
        this.token = token;
        this.origin = origin;
        this.url = url;
    }

    @Override
    public Long id() {
        return this.origin.getLong("id");
    }

    @Override
    public String name() {
        return this.origin.getString("name");
    }

    @Override
    public Optional<Long> parentId() {
        return new OptionalLongOf(this.origin, "parentId").get();
    }

    @Override
    public Optional<String> parentName() {
        return new OptionalStringOf(this.origin, "parentName").get();
    }

    @Override
    public boolean isCustom() {
        return this.origin.getBoolean("isCustom");
    }

    @Override
    public Iterable<Long> children() {
        return new IterableJsonArray<Long>(this.origin.getJSONArray("children"), JSONArray::getLong);
    }

    @Override
    public Category edit(FpEditParameters parameters) {
        return new FpCategory(this.endpoint, this.token, new JSONObject(this.endpoint.patch(String.format("%s/%d", this.url, this.id()), this.token, parameters)), this.url);
    }

    @Override
    public void delete() {
        this.endpoint.delete(String.format("%s/%d", this.url, this.id()), this.token, new NameValuePair[0]);
    }
}

