/*
 * Decompiled with CFR 0.152.
 */
package org.proshin.finapi.category.in;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import org.json.JSONArray;
import org.json.JSONObject;
import org.proshin.finapi.Jsonable;
import org.proshin.finapi.account.Type;

public final class TrainCategorizationParameters
implements Jsonable {
    private final JSONObject origin;

    public TrainCategorizationParameters() {
        this(new JSONObject());
    }

    public TrainCategorizationParameters(JSONObject origin) {
        this.origin = origin;
    }

    public TrainCategorizationParameters withTransactions(TrainCategorizationTransaction ... transactions) {
        this.origin.put("transactionData", (Object)new JSONArray((Collection)Arrays.stream(transactions).map(tx -> new JSONObject(tx.asString())).collect(Collectors.toList())));
        return this;
    }

    public TrainCategorizationParameters withCategory(Long category) {
        this.origin.put("categoryId", (Object)category);
        return this;
    }

    @Override
    public JSONObject asJson() {
        return this.origin;
    }

    public static final class TrainCategorizationTransaction
    implements Jsonable {
        private final JSONObject origin;

        public TrainCategorizationTransaction() {
            this(new JSONObject());
        }

        public TrainCategorizationTransaction(JSONObject origin) {
            this.origin = origin;
        }

        public TrainCategorizationTransaction withAccountType(Type type) {
            this.origin.put("accountTypeId", type.asCode());
            return this;
        }

        public TrainCategorizationTransaction withAmount(BigDecimal amount) {
            this.origin.put("amount", (Object)amount);
            return this;
        }

        public TrainCategorizationTransaction withPurpose(String purpose) {
            this.origin.put("purpose", (Object)purpose);
            return this;
        }

        public TrainCategorizationTransaction withCounterpart(String counterpart) {
            this.origin.put("counterpart", (Object)counterpart);
            return this;
        }

        public TrainCategorizationTransaction withCounterpartIban(String counterpartIban) {
            this.origin.put("counterpartIban", (Object)counterpartIban);
            return this;
        }

        public TrainCategorizationTransaction withCounterpartAccountNumber(String counterpartAccountNumber) {
            this.origin.put("counterpartAccountNumber", (Object)counterpartAccountNumber);
            return this;
        }

        public TrainCategorizationTransaction withCounterpartBlz(String counterpartBlz) {
            this.origin.put("counterpartBlz", (Object)counterpartBlz);
            return this;
        }

        public TrainCategorizationTransaction withCounterpartBic(String counterpartBic) {
            this.origin.put("counterpartBic", (Object)counterpartBic);
            return this;
        }

        public TrainCategorizationTransaction withMcCode(String mcCode) {
            this.origin.put("mcCode", (Object)mcCode);
            return this;
        }

        @Override
        public JSONObject asJson() {
            return this.origin;
        }
    }
}

