/*
 * Decompiled with CFR 0.152.
 */
package org.proshin.finapi.category.out;

import java.math.BigDecimal;
import java.util.Optional;
import org.json.JSONObject;
import org.proshin.finapi.accesstoken.AccessToken;
import org.proshin.finapi.category.Category;
import org.proshin.finapi.category.FpCategory;
import org.proshin.finapi.category.out.CashFlow;
import org.proshin.finapi.endpoint.Endpoint;
import org.proshin.finapi.primitives.optional.OptionalObjectOf;

public final class FpCashFlow
implements CashFlow {
    private final Endpoint endpoint;
    private final AccessToken token;
    private final JSONObject origin;
    private final String url;

    public FpCashFlow(Endpoint endpoint, AccessToken token, JSONObject origin, String url) {
        this.endpoint = endpoint;
        this.token = token;
        this.origin = origin;
        this.url = url;
    }

    @Override
    public Optional<Category> category() {
        return ((Optional)new OptionalObjectOf(this.origin, "category").get()).map(json -> new FpCategory(this.endpoint, this.token, (JSONObject)json, this.url));
    }

    @Override
    public BigDecimal income() {
        return this.origin.getBigDecimal("income");
    }

    @Override
    public BigDecimal spending() {
        return this.origin.getBigDecimal("spending");
    }

    @Override
    public BigDecimal balance() {
        return this.origin.getBigDecimal("balance");
    }

    @Override
    public int countIncomeTransactions() {
        return this.origin.getInt("countIncomeTransactions");
    }

    @Override
    public int countSpendingTransactions() {
        return this.origin.getInt("countSpendingTransactions");
    }

    @Override
    public int countAllTransactions() {
        return this.origin.getInt("countAllTransactions");
    }
}

