/*
 * Decompiled with CFR 0.152.
 */
package org.proshin.finapi.exception;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.OffsetDateTime;
import java.util.Optional;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.cactoos.Input;
import org.cactoos.io.InputOf;
import org.cactoos.text.TextOf;
import org.json.JSONObject;
import org.proshin.finapi.exception.FinapiError;
import org.proshin.finapi.primitives.IterableJsonArray;
import org.proshin.finapi.primitives.OffsetDateTimeOf;

public final class FinapiException
extends RuntimeException {
    private static final long serialVersionUID = -5608855544688297953L;
    private final transient JSONObject origin;
    private final transient Optional<String> location;

    public FinapiException(int expected, HttpResponse response) {
        super(String.format("Unexpected response code: expected=%d, actual=%s", expected, response.getStatusLine().getStatusCode()));
        String content;
        try {
            content = new TextOf((Input)new InputOf(response.getEntity().getContent()), StandardCharsets.UTF_8).asString();
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't read the response body", e);
        }
        this.origin = new JSONObject(content);
        this.location = Optional.ofNullable(response.getFirstHeader("Location")).map(NameValuePair::getValue);
    }

    public Iterable<FinapiError> errors() {
        return new IterableJsonArray<FinapiError>(this.origin.getJSONArray("errors"), (array, index) -> new FinapiError(array.getJSONObject(index.intValue())));
    }

    public OffsetDateTime date() {
        return new OffsetDateTimeOf(this.origin.getString("date")).get();
    }

    public String requestId() {
        return this.origin.getString("requestId");
    }

    public String endpoint() {
        return this.origin.getString("endpoint");
    }

    public String authContext() {
        return this.origin.getString("authContext");
    }

    public String bank() {
        return this.origin.getString("bank");
    }

    public Optional<String> location() {
        return this.location;
    }
}

