/*
 * Decompiled with CFR 0.152.
 */
package org.proshin.finapi.primitives.paging;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.function.Supplier;
import org.apache.http.NameValuePair;
import org.proshin.finapi.primitives.pair.UrlEncodedPair;

public final class PagingCriteria
implements Iterable<NameValuePair> {
    private final Supplier<? extends Iterator<NameValuePair>> origin;

    public PagingCriteria(int page, int perPage, String ... orders) {
        this(() -> {
            ArrayList<UrlEncodedPair> list = new ArrayList<UrlEncodedPair>();
            list.add(new UrlEncodedPair("page", page));
            list.add(new UrlEncodedPair("perPage", perPage));
            for (String order : orders) {
                list.add(new UrlEncodedPair("order", order));
            }
            return list.iterator();
        });
    }

    public PagingCriteria(Supplier<? extends Iterator<NameValuePair>> origin) {
        this.origin = origin;
    }

    @Override
    public Iterator<NameValuePair> iterator() {
        return this.origin.get();
    }
}

