/*
 * Decompiled with CFR 0.152.
 */
package org.proshin.finapi.primitives.pair;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;

public final class UrlEncodedPair
implements NameValuePair {
    private final NameValuePair origin;

    public UrlEncodedPair(String name, Object value) {
        this(name, value.toString());
    }

    public UrlEncodedPair(String name, String value) {
        this((NameValuePair)new BasicNameValuePair(name, value));
    }

    public UrlEncodedPair(NameValuePair origin) {
        this.origin = origin;
    }

    public String getName() {
        return this.origin.getName();
    }

    public String getValue() {
        try {
            return URLEncoder.encode(this.origin.getValue(), StandardCharsets.UTF_8.displayName());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

