/*
 * Decompiled with CFR 0.152.
 */
package org.proshin.finapi.user;

import java.util.Optional;
import org.apache.http.NameValuePair;
import org.json.JSONObject;
import org.proshin.finapi.accesstoken.AccessToken;
import org.proshin.finapi.account.Accounts;
import org.proshin.finapi.account.FpAccounts;
import org.proshin.finapi.bankconnection.BankConnections;
import org.proshin.finapi.bankconnection.FpBankConnections;
import org.proshin.finapi.category.Categories;
import org.proshin.finapi.category.FpCategories;
import org.proshin.finapi.endpoint.Endpoint;
import org.proshin.finapi.label.FpLabels;
import org.proshin.finapi.label.Labels;
import org.proshin.finapi.mock.FpMocksAndTests;
import org.proshin.finapi.mock.MocksAndTests;
import org.proshin.finapi.notificationrule.FpNotificationRules;
import org.proshin.finapi.notificationrule.NotificationRules;
import org.proshin.finapi.security.FpSecurities;
import org.proshin.finapi.security.Securities;
import org.proshin.finapi.transaction.FpTransactions;
import org.proshin.finapi.transaction.Transactions;
import org.proshin.finapi.user.AuthorizedUser;
import org.proshin.finapi.user.FpUser;
import org.proshin.finapi.user.User;
import org.proshin.finapi.webform.FpWebForms;
import org.proshin.finapi.webform.WebForms;

public final class FpAuthorizedUser
implements AuthorizedUser {
    private final Endpoint endpoint;
    private final AccessToken token;
    private final User origin;
    private final String url;

    public FpAuthorizedUser(Endpoint endpoint, AccessToken token) {
        this(endpoint, token, "/api/v1/users");
    }

    public FpAuthorizedUser(Endpoint endpoint, AccessToken token, String url) {
        this(endpoint, token, url, new FpUser(new JSONObject(endpoint.get(url, token, new NameValuePair[0]))));
    }

    public FpAuthorizedUser(Endpoint endpoint, AccessToken token, String url, User origin) {
        this.endpoint = endpoint;
        this.token = token;
        this.origin = origin;
        this.url = url;
    }

    @Override
    public String id() {
        return this.origin.id();
    }

    @Override
    public String password() {
        return this.origin.password();
    }

    @Override
    public Optional<String> email() {
        return this.origin.email();
    }

    @Override
    public Optional<String> phone() {
        return this.origin.phone();
    }

    @Override
    public boolean isAutoUpdateEnabled() {
        return this.origin.isAutoUpdateEnabled();
    }

    @Override
    public AuthorizedUser edit(String email, String phone, boolean isAutoUpdateEnabled) {
        return new FpAuthorizedUser(this.endpoint, this.token, this.url, new FpUser(new JSONObject(this.endpoint.post(this.url, this.token, () -> new JSONObject().put("email", (Object)email).put("phone", (Object)phone).put("isAutoUpdateEnabled", isAutoUpdateEnabled)))));
    }

    @Override
    public void delete() {
        this.endpoint.delete(this.url, this.token, new NameValuePair[0]);
    }

    @Override
    public BankConnections connections() {
        return new FpBankConnections(this.endpoint, this.token);
    }

    @Override
    public Accounts accounts() {
        return new FpAccounts(this.endpoint, this.token);
    }

    @Override
    public Transactions transactions() {
        return new FpTransactions(this.endpoint, this.token);
    }

    @Override
    public Securities securities() {
        return new FpSecurities(this.endpoint, this.token);
    }

    @Override
    public Categories categories() {
        return new FpCategories(this.endpoint, this.token);
    }

    @Override
    public Labels labels() {
        return new FpLabels(this.endpoint, this.token);
    }

    @Override
    public NotificationRules notificationRules() {
        return new FpNotificationRules(this.endpoint, this.token);
    }

    @Override
    public WebForms webForms() {
        return new FpWebForms(this.endpoint, this.token);
    }

    @Override
    public MocksAndTests mocksAndTests() {
        return new FpMocksAndTests(this.endpoint, this.token);
    }
}

