/*
 * Decompiled with CFR 0.152.
 */
package org.proshin.finapi.account;

import java.time.OffsetDateTime;
import java.util.Optional;
import org.json.JSONObject;
import org.proshin.finapi.account.AccountInterface;
import org.proshin.finapi.account.out.Capability;
import org.proshin.finapi.account.out.Status;
import org.proshin.finapi.primitives.BankingInterface;
import org.proshin.finapi.primitives.IterableJsonArray;
import org.proshin.finapi.primitives.optional.OptionalOffsetDateTimeOf;

public class FpAccountInterface
implements AccountInterface {
    private final JSONObject origin;

    public FpAccountInterface(JSONObject origin) {
        this.origin = origin;
    }

    @Override
    public BankingInterface bankingInterface() {
        return BankingInterface.valueOf(this.origin.getString("interface"));
    }

    @Override
    public Status status() {
        return Status.valueOf(this.origin.getString("status"));
    }

    @Override
    public Iterable<Capability> capabilities() {
        return new IterableJsonArray<Capability>(this.origin.getJSONArray("capabilities"), (json, index) -> Capability.valueOf(json.getString(index.intValue())));
    }

    @Override
    public Optional<OffsetDateTime> lastSuccessfulUpdate() {
        return new OptionalOffsetDateTimeOf(this.origin, "lastSuccessfulUpdate").get();
    }

    @Override
    public Optional<OffsetDateTime> lastUpdateAttempt() {
        return new OptionalOffsetDateTimeOf(this.origin, "lastUpdateAttempt").get();
    }
}

