/*
 * Decompiled with CFR 0.152.
 */
package org.proshin.finapi.account.in;

import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.http.NameValuePair;
import org.proshin.finapi.account.Type;
import org.proshin.finapi.primitives.StringOf;
import org.proshin.finapi.primitives.pair.CommaSeparatedPair;
import org.proshin.finapi.primitives.pair.UrlEncodedPair;

public final class FpQueryCriteria
implements Iterable<NameValuePair> {
    private final List<NameValuePair> pairs;

    public FpQueryCriteria() {
        this(new ArrayList<NameValuePair>());
    }

    public FpQueryCriteria(List<NameValuePair> pairs) {
        this.pairs = pairs;
    }

    public FpQueryCriteria withIds(Iterable<Long> ids) {
        this.pairs.add(new UrlEncodedPair(new CommaSeparatedPair<Long>("ids", ids)));
        return this;
    }

    public FpQueryCriteria withSearch(String search) {
        this.pairs.add(new UrlEncodedPair("search", search));
        return this;
    }

    public FpQueryCriteria withTypes(Type ... types) {
        this.pairs.add(new UrlEncodedPair(new CommaSeparatedPair("accountTypes", Arrays.stream(types).map(Enum::name).collect(Collectors.toList()))));
        return this;
    }

    public FpQueryCriteria withBankConnections(Iterable<Long> ids) {
        this.pairs.add(new UrlEncodedPair(new CommaSeparatedPair<Long>("bankConnectionIds", ids)));
        return this;
    }

    public FpQueryCriteria withMinLastSuccessfulUpdate(OffsetDateTime minLastSuccessfulUpdate) {
        this.pairs.add(new UrlEncodedPair("minLastSuccessfulUpdate", new StringOf(minLastSuccessfulUpdate)));
        return this;
    }

    public FpQueryCriteria withMaxLastSuccessfulUpdate(OffsetDateTime maxLastSuccessfulUpdate) {
        this.pairs.add(new UrlEncodedPair("maxLastSuccessfulUpdate", new StringOf(maxLastSuccessfulUpdate)));
        return this;
    }

    public FpQueryCriteria withMinBalance(BigDecimal minBalance) {
        this.pairs.add(new UrlEncodedPair("minBalance", new StringOf(minBalance)));
        return this;
    }

    public FpQueryCriteria withMaxBalance(BigDecimal maxBalance) {
        this.pairs.add(new UrlEncodedPair("maxBalance", new StringOf(maxBalance)));
        return this;
    }

    @Override
    public Iterator<NameValuePair> iterator() {
        return this.pairs.iterator();
    }
}

