/*
 * Decompiled with CFR 0.152.
 */
package org.proshin.finapi.bank.out;

import java.time.OffsetDateTime;
import java.util.Optional;
import org.json.JSONObject;
import org.proshin.finapi.bank.out.BankInterface;
import org.proshin.finapi.bank.out.FpLoginCredential;
import org.proshin.finapi.bank.out.LoginCredential;
import org.proshin.finapi.primitives.BankingInterface;
import org.proshin.finapi.primitives.IterableJsonArray;
import org.proshin.finapi.primitives.optional.OptionalOffsetDateTimeOf;
import org.proshin.finapi.primitives.optional.OptionalStringOf;
import org.proshin.finapi.tppcredential.FpTppAuthenticationGroup;
import org.proshin.finapi.tppcredential.TppAuthenticationGroup;

public class FpBankInterface
implements BankInterface {
    private final JSONObject origin;

    public FpBankInterface(JSONObject origin) {
        this.origin = origin;
    }

    @Override
    public BankingInterface bankingInterface() {
        return BankingInterface.valueOf(this.origin.getString("interface"));
    }

    @Override
    public Optional<TppAuthenticationGroup> tppAuthenticationGroup() {
        return Optional.ofNullable(this.origin.getJSONObject("tppAuthenticationGroup")).map(FpTppAuthenticationGroup::new);
    }

    @Override
    public Iterable<LoginCredential> loginCredentials() {
        return new IterableJsonArray<LoginCredential>(this.origin.getJSONArray("loginCredentials"), (array, index) -> new FpLoginCredential(array.getJSONObject(index.intValue())));
    }

    @Override
    public Iterable<BankInterface.BankInterfaceProperty> properties() {
        return new IterableJsonArray<BankInterface.BankInterfaceProperty>(this.origin.getJSONArray("properties"), (array, index) -> BankInterface.BankInterfaceProperty.valueOf(array.getString(index.intValue())));
    }

    @Override
    public Optional<String> loginHint() {
        return new OptionalStringOf(this.origin, "loginHint").get();
    }

    @Override
    public int health() {
        return this.origin.getInt("health");
    }

    @Override
    public Optional<OffsetDateTime> lastCommunicationAttempt() {
        return new OptionalOffsetDateTimeOf(this.origin, "lastCommunicationAttempt").get();
    }

    @Override
    public Optional<OffsetDateTime> lastSuccessfulCommunication() {
        return new OptionalOffsetDateTimeOf(this.origin, "lastSuccessfulCommunication").get();
    }
}

