/*
 * Decompiled with CFR 0.152.
 */
package org.proshin.finapi.bankconnection;

import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.http.NameValuePair;
import org.json.JSONArray;
import org.json.JSONObject;
import org.proshin.finapi.accesstoken.AccessToken;
import org.proshin.finapi.bankconnection.BankConnection;
import org.proshin.finapi.bankconnection.BankConnections;
import org.proshin.finapi.bankconnection.FpBankConnection;
import org.proshin.finapi.bankconnection.in.ImportBankConnectionParameters;
import org.proshin.finapi.bankconnection.in.UpdateBankConnectionParameters;
import org.proshin.finapi.endpoint.Endpoint;
import org.proshin.finapi.primitives.IterableJsonArray;
import org.proshin.finapi.primitives.pair.CommaSeparatedPair;

public final class FpBankConnections
implements BankConnections {
    private final Endpoint endpoint;
    private final AccessToken token;
    private final String url;

    public FpBankConnections(Endpoint endpoint, AccessToken token) {
        this(endpoint, token, "/api/v1/bankConnections");
    }

    public FpBankConnections(Endpoint endpoint, AccessToken token, String url) {
        this.endpoint = endpoint;
        this.token = token;
        this.url = url;
    }

    @Override
    public BankConnection one(Long id) {
        return new FpBankConnection(this.endpoint, this.token, new JSONObject(this.endpoint.get(String.format("%s/%d", this.url, id), this.token, new NameValuePair[0])), this.url);
    }

    @Override
    public Iterable<BankConnection> query(Iterable<Long> ids) {
        return new IterableJsonArray<BankConnection>(new JSONObject(this.endpoint.get(this.url, this.token, new CommaSeparatedPair<Long>("ids", ids))).getJSONArray("connections"), (array, index) -> new FpBankConnection(this.endpoint, this.token, array.getJSONObject(index.intValue()), this.url));
    }

    @Override
    public Future<BankConnection> importNew(ImportBankConnectionParameters parameters) {
        return Executors.newSingleThreadExecutor().submit(() -> new FpBankConnection(this.endpoint, this.token, new JSONObject(this.endpoint.post(this.url + "/import", this.token, parameters, 201)), this.url));
    }

    @Override
    public Future<BankConnection> update(UpdateBankConnectionParameters parameters) {
        return Executors.newSingleThreadExecutor().submit(() -> new FpBankConnection(this.endpoint, this.token, new JSONObject(this.endpoint.post(this.url + "/update", this.token, parameters)), this.url));
    }

    @Override
    public Iterable<Long> deleteAll() {
        return new IterableJsonArray<Long>(new JSONObject(this.endpoint.delete(this.url, this.token, new NameValuePair[0])).getJSONArray("identifiers"), JSONArray::getLong);
    }
}

