/*
 * Decompiled with CFR 0.152.
 */
package org.proshin.finapi.bankconnection.in;

import java.util.Map;
import org.json.JSONObject;
import org.proshin.finapi.Jsonable;
import org.proshin.finapi.primitives.BankingInterface;
import org.proshin.finapi.primitives.MultiStepAuthentication;

public class ConnectInterfaceParameters
implements Jsonable {
    private final JSONObject origin;

    public ConnectInterfaceParameters() {
        this(new JSONObject());
    }

    public ConnectInterfaceParameters(JSONObject origin) {
        this.origin = origin;
    }

    public ConnectInterfaceParameters withInterface(BankingInterface bankingInterface) {
        this.origin.put("interface", (Object)bankingInterface.name());
        return this;
    }

    public ConnectInterfaceParameters withLoginCredentials(Map<String, String> credentials) {
        credentials.forEach((label, value) -> this.origin.append("loginCredentials", (Object)new JSONObject().put("label", label).put("value", value)));
        return this;
    }

    public ConnectInterfaceParameters withStoreSecrets() {
        this.origin.put("storeSecrets", true);
        return this;
    }

    public ConnectInterfaceParameters withSkipPositionsDownload() {
        this.origin.put("skipPositionsDownload", true);
        return this;
    }

    public ConnectInterfaceParameters withLoadOwnerData() {
        this.origin.put("loadOwnerData", true);
        return this;
    }

    public ConnectInterfaceParameters withAccountReferences(Iterable<String> ibans) {
        ibans.forEach(iban -> this.origin.append("accountReferences", (Object)new JSONObject().put("iban", iban)));
        return this;
    }

    public ConnectInterfaceParameters withMultiStepAuthentication(MultiStepAuthentication multiStepAuthentication) {
        this.origin.put("multiStepAuthentication", (Object)multiStepAuthentication.asJson());
        return this;
    }

    public ConnectInterfaceParameters withRedirectUrl(String redirectUrl) {
        this.origin.put("redirectUrl", (Object)redirectUrl);
        return this;
    }

    @Override
    public JSONObject asJson() {
        return this.origin;
    }
}

