/*
 * Decompiled with CFR 0.152.
 */
package org.proshin.finapi.bankconnection.in;

import java.util.Collection;
import java.util.Map;
import org.cactoos.collection.Mapped;
import org.json.JSONObject;
import org.proshin.finapi.Jsonable;
import org.proshin.finapi.account.Type;
import org.proshin.finapi.primitives.BankingInterface;
import org.proshin.finapi.primitives.MultiStepAuthentication;

public final class ImportBankConnectionParameters
implements Jsonable {
    private final JSONObject origin;

    public ImportBankConnectionParameters() {
        this(new JSONObject());
    }

    public ImportBankConnectionParameters(JSONObject origin) {
        this.origin = origin;
    }

    public ImportBankConnectionParameters withBank(Long bankId) {
        this.origin.put("bankId", (Object)bankId);
        return this;
    }

    public ImportBankConnectionParameters withName(String name) {
        this.origin.put("name", (Object)name);
        return this;
    }

    @Deprecated
    public ImportBankConnectionParameters withUserId(String userId) {
        this.origin.put("bankingUserId", (Object)userId);
        return this;
    }

    @Deprecated
    public ImportBankConnectionParameters withCustomerId(String customerId) {
        this.origin.put("bankingCustomerId", (Object)customerId);
        return this;
    }

    @Deprecated
    public ImportBankConnectionParameters withPin(String pin) {
        this.origin.put("bankingPin", (Object)pin);
        return this;
    }

    @Deprecated
    public ImportBankConnectionParameters withStorePin() {
        this.origin.put("storePin", true);
        return this;
    }

    public ImportBankConnectionParameters withBankingInterface(BankingInterface bankingInterface) {
        this.origin.put("interface", (Object)bankingInterface.name());
        return this;
    }

    public ImportBankConnectionParameters withLoginCredentials(Map<String, String> credentials) {
        credentials.forEach((label, value) -> this.origin.append("loginCredentials", (Object)new JSONObject().put("label", label).put("value", value)));
        return this;
    }

    public ImportBankConnectionParameters withStoreSecrets() {
        this.origin.put("storeSecrets", true);
        return this;
    }

    public ImportBankConnectionParameters withSkipPositionsDownload() {
        this.origin.put("skipPositionsDownload", true);
        return this;
    }

    public ImportBankConnectionParameters withLoadOwnerData() {
        this.origin.put("loadOwnerData", true);
        return this;
    }

    public ImportBankConnectionParameters withMaxDaysForDownload(int days) {
        this.origin.put("maxDaysForDownload", days);
        return this;
    }

    public ImportBankConnectionParameters withAccountTypes(Iterable<Type> types) {
        this.origin.put("accountTypes", (Collection)new Mapped(Enum::name, types));
        return this;
    }

    public ImportBankConnectionParameters withAccountReferences(Iterable<String> ibans) {
        ibans.forEach(iban -> this.origin.append("accountReferences", (Object)new JSONObject().put("iban", iban)));
        return this;
    }

    @Deprecated
    public ImportBankConnectionParameters withChallengeResponse(String challengeResponse) {
        this.origin.put("challengeResponse", (Object)challengeResponse);
        return this;
    }

    public ImportBankConnectionParameters withMultiStepAuthentication(MultiStepAuthentication multiStepAuthentication) {
        this.origin.put("multiStepAuthentication", (Object)multiStepAuthentication.asJson());
        return this;
    }

    public ImportBankConnectionParameters withRedirectUrl(String redirectUrl) {
        this.origin.put("redirectUrl", (Object)redirectUrl);
        return this;
    }

    @Override
    public JSONObject asJson() {
        return this.origin;
    }
}

