/*
 * Decompiled with CFR 0.152.
 */
package org.proshin.finapi.bankconnection.in;

import java.util.Map;
import org.json.JSONObject;
import org.proshin.finapi.Jsonable;
import org.proshin.finapi.primitives.BankingInterface;
import org.proshin.finapi.primitives.MultiStepAuthentication;

public final class UpdateBankConnectionParameters
implements Jsonable {
    private final JSONObject origin;

    public UpdateBankConnectionParameters() {
        this(new JSONObject());
    }

    public UpdateBankConnectionParameters(JSONObject origin) {
        this.origin = origin;
    }

    public UpdateBankConnectionParameters withBankConnection(Long connectionId) {
        this.origin.put("bankConnectionId", (Object)connectionId);
        return this;
    }

    @Deprecated
    public UpdateBankConnectionParameters withPin(String pin) {
        this.origin.put("bankingPin", (Object)pin);
        return this;
    }

    @Deprecated
    public UpdateBankConnectionParameters withStorePin() {
        this.origin.put("storePin", true);
        return this;
    }

    public UpdateBankConnectionParameters withBankingInterface(BankingInterface bankingInterface) {
        this.origin.put("interface", (Object)bankingInterface);
        return this;
    }

    public UpdateBankConnectionParameters withLoginCredentials(Map<String, String> credentials) {
        credentials.forEach((label, value) -> this.origin.append("loginCredentials", (Object)new JSONObject().put("label", label).put("value", value)));
        return this;
    }

    public UpdateBankConnectionParameters withStoreSecrets() {
        this.origin.put("storeSecrets", true);
        return this;
    }

    public UpdateBankConnectionParameters withImportNewAccounts() {
        this.origin.put("importNewAccounts", true);
        return this;
    }

    public UpdateBankConnectionParameters withSkipPositionsDownload() {
        this.origin.put("skipPositionsDownload", true);
        return this;
    }

    public UpdateBankConnectionParameters withLoadOwnerData() {
        this.origin.put("loadOwnerData", true);
        return this;
    }

    public UpdateBankConnectionParameters withAccountReferences(Iterable<String> ibans) {
        ibans.forEach(iban -> this.origin.append("accountReferences", (Object)new JSONObject().put("iban", iban)));
        return this;
    }

    @Deprecated
    public UpdateBankConnectionParameters withChallengeResponse(String challengeResponse) {
        this.origin.put("challengeResponse", (Object)challengeResponse);
        return this;
    }

    public UpdateBankConnectionParameters withMultiStepAuthentication(MultiStepAuthentication multiStepAuthentication) {
        this.origin.put("multiStepAuthentication", (Object)multiStepAuthentication.asJson());
        return this;
    }

    public UpdateBankConnectionParameters withRedirectUrl(String redirectUrl) {
        this.origin.put("redirectUrl", (Object)redirectUrl);
        return this;
    }

    @Override
    public JSONObject asJson() {
        return this.origin;
    }
}

