/*
 * Decompiled with CFR 0.152.
 */
package org.proshin.finapi.bankconnection.out;

import java.util.Optional;
import org.json.JSONObject;
import org.proshin.finapi.bankconnection.out.BankConnectionInterface;
import org.proshin.finapi.bankconnection.out.BankConsent;
import org.proshin.finapi.bankconnection.out.FpBankConsent;
import org.proshin.finapi.bankconnection.out.FpLoginCredential;
import org.proshin.finapi.bankconnection.out.FpTwoStepProcedures;
import org.proshin.finapi.bankconnection.out.FpUpdateResult;
import org.proshin.finapi.bankconnection.out.LoginCredential;
import org.proshin.finapi.bankconnection.out.TwoStepProcedures;
import org.proshin.finapi.bankconnection.out.UpdateResult;
import org.proshin.finapi.primitives.BankingInterface;
import org.proshin.finapi.primitives.IterableJsonArray;
import org.proshin.finapi.primitives.optional.OptionalObjectOf;

public class FpBankConnectionInterface
implements BankConnectionInterface {
    private final JSONObject origin;

    public FpBankConnectionInterface(JSONObject origin) {
        this.origin = origin;
    }

    @Override
    public BankingInterface bankingInterface() {
        return BankingInterface.valueOf(this.origin.getString("interface"));
    }

    @Override
    public Iterable<LoginCredential> credentials() {
        return new IterableJsonArray<LoginCredential>(this.origin.getJSONArray("loginCredentials"), (array, index) -> new FpLoginCredential(array.getJSONObject(index.intValue())));
    }

    @Override
    public TwoStepProcedures twoStepProcedures() {
        return new FpTwoStepProcedures(this.origin);
    }

    @Override
    public BankConsent aisConsent() {
        return new FpBankConsent(this.origin.getJSONObject("aisConsent"));
    }

    @Override
    public Optional<UpdateResult> lastManualUpdate() {
        return ((Optional)new OptionalObjectOf(this.origin, "lastManualUpdate").get()).map(FpUpdateResult::new);
    }

    @Override
    public Optional<UpdateResult> lastAutoUpdate() {
        return ((Optional)new OptionalObjectOf(this.origin, "lastAutoUpdate").get()).map(FpUpdateResult::new);
    }
}

