/*
 * Decompiled with CFR 0.152.
 */
package org.proshin.finapi.client;

import org.apache.http.NameValuePair;
import org.json.JSONObject;
import org.proshin.finapi.accesstoken.AccessToken;
import org.proshin.finapi.client.Client;
import org.proshin.finapi.client.in.EditClientParameters;
import org.proshin.finapi.client.out.Configuration;
import org.proshin.finapi.client.out.FpConfiguration;
import org.proshin.finapi.endpoint.Endpoint;
import org.proshin.finapi.user.FpUsers;
import org.proshin.finapi.user.Users;

public final class FpClient
implements Client {
    private final Endpoint endpoint;
    private final AccessToken token;
    private final String url;

    public FpClient(Endpoint endpoint, AccessToken token) {
        this(endpoint, token, "/api/v1/clientConfiguration");
    }

    public FpClient(Endpoint endpoint, AccessToken token, String url) {
        this.endpoint = endpoint;
        this.token = token;
        this.url = url;
    }

    @Override
    public Configuration configuration() {
        return new FpConfiguration(new JSONObject(this.endpoint.get(this.url, this.token, new NameValuePair[0])));
    }

    @Override
    public Configuration edit(EditClientParameters parameters) {
        return new FpConfiguration(new JSONObject(this.endpoint.patch(this.url, this.token, parameters)));
    }

    @Override
    public Users users() {
        return new FpUsers(this.endpoint, this.token);
    }
}

