/*
 * Decompiled with CFR 0.152.
 */
package org.proshin.finapi.endpoint;

import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.ParseException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicHeaderElement;
import org.cactoos.Input;
import org.cactoos.Text;
import org.cactoos.io.InputOf;
import org.cactoos.list.ListOf;
import org.cactoos.text.FormattedText;
import org.cactoos.text.TextOf;
import org.cactoos.text.UncheckedText;
import org.proshin.finapi.Jsonable;
import org.proshin.finapi.accesstoken.AccessToken;
import org.proshin.finapi.endpoint.Endpoint;
import org.proshin.finapi.exception.FinapiException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FpEndpoint
implements Endpoint {
    private static final Logger LOGGER = LoggerFactory.getLogger(FpEndpoint.class);
    private final HttpClient client;
    private final String endpoint;

    public FpEndpoint(String endpoint) {
        this((HttpClient)HttpClientBuilder.create().build(), endpoint);
    }

    public FpEndpoint(HttpClient client, String endpoint) {
        this.client = client;
        this.endpoint = endpoint;
    }

    @Override
    public String get(String path, AccessToken token, Iterable<NameValuePair> parameters) {
        try {
            URIBuilder builder = new URIBuilder(this.endpoint + path);
            builder.setParameters((List)new ListOf(parameters));
            HttpGet get = new HttpGet(builder.build());
            get.addHeader((Header)new AuthorizationHeader(token.accessToken()));
            HttpResponse response = this.client.execute((HttpUriRequest)get);
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new FinapiException(200, response);
            }
            String responseBody = new TextOf((Input)new InputOf(response.getEntity().getContent()), StandardCharsets.UTF_8).asString();
            LOGGER.info("Response body was: {}", (Object)responseBody);
            return responseBody;
        }
        catch (IOException | URISyntaxException e) {
            throw new RuntimeException(new UncheckedText((Text)new FormattedText("Couldn't get '%s'", new Object[]{path})).asString(), e);
        }
    }

    @Override
    public String delete(String path, AccessToken token, Iterable<NameValuePair> parameters) {
        try {
            URIBuilder builder = new URIBuilder(this.endpoint + path);
            builder.setParameters((List)new ListOf(parameters));
            HttpDelete delete = new HttpDelete(builder.build());
            delete.addHeader((Header)new AuthorizationHeader(token.accessToken()));
            HttpResponse response = this.client.execute((HttpUriRequest)delete);
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new FinapiException(200, response);
            }
            String responseBody = new TextOf((Input)new InputOf(response.getEntity().getContent()), StandardCharsets.UTF_8).asString();
            LOGGER.info("Response body was: {}", (Object)responseBody);
            return responseBody;
        }
        catch (IOException | URISyntaxException e) {
            throw new IllegalStateException(new UncheckedText((Text)new FormattedText("Couldn't delete '%s'", new Object[]{path})).asString(), e);
        }
    }

    @Override
    public HttpPost post(String path) {
        return new HttpPost(this.endpoint + path);
    }

    @Override
    public String post(String path, HttpEntity entity, int expected) {
        try {
            HttpPost post = new HttpPost(this.endpoint + path);
            post.setEntity(entity);
            HttpResponse response = this.client.execute((HttpUriRequest)post);
            if (response.getStatusLine().getStatusCode() != expected) {
                throw new FinapiException(expected, response);
            }
            return new TextOf((Input)new InputOf(response.getEntity().getContent()), StandardCharsets.UTF_8).asString();
        }
        catch (IOException e) {
            throw new IllegalStateException(new UncheckedText((Text)new FormattedText("Couldn't post to '%s'", new Object[]{path})).asString());
        }
    }

    @Override
    public HttpPost post(String path, AccessToken token) {
        HttpPost post = this.post(path);
        post.addHeader((Header)new AuthorizationHeader(token.accessToken()));
        return post;
    }

    @Override
    public String post(String path, AccessToken token, int expected) {
        try {
            HttpPost post = new HttpPost(this.endpoint + path);
            post.addHeader((Header)new AuthorizationHeader(token.accessToken()));
            HttpResponse response = this.client.execute((HttpUriRequest)post);
            if (response.getStatusLine().getStatusCode() != expected) {
                throw new FinapiException(expected, response);
            }
            return new TextOf((Input)new InputOf(response.getEntity().getContent()), StandardCharsets.UTF_8).asString();
        }
        catch (IOException e) {
            throw new IllegalStateException(new UncheckedText((Text)new FormattedText("Couldn't post to '%s'", new Object[]{path})).asString());
        }
    }

    @Override
    public String post(String path, AccessToken token, HttpEntity entity, int expected) {
        try {
            HttpPost post = new HttpPost(this.endpoint + path);
            post.addHeader((Header)new AuthorizationHeader(token.accessToken()));
            post.setEntity(entity);
            HttpResponse response = this.client.execute((HttpUriRequest)post);
            if (response.getStatusLine().getStatusCode() != expected) {
                throw new FinapiException(expected, response);
            }
            return new TextOf((Input)new InputOf(response.getEntity().getContent()), StandardCharsets.UTF_8).asString();
        }
        catch (IOException e) {
            throw new IllegalStateException(new UncheckedText((Text)new FormattedText("Couldn't post to '%s'", new Object[]{path})).asString());
        }
    }

    @Override
    public String patch(String path, AccessToken token, HttpEntity entity, int expected) {
        try {
            HttpPatch patch = new HttpPatch(this.endpoint + path);
            patch.addHeader((Header)new AuthorizationHeader(token.accessToken()));
            patch.setEntity(entity);
            HttpResponse response = this.client.execute((HttpUriRequest)patch);
            if (response.getStatusLine().getStatusCode() != expected) {
                throw new FinapiException(expected, response);
            }
            return new TextOf((Input)new InputOf(response.getEntity().getContent()), StandardCharsets.UTF_8).asString();
        }
        catch (IOException e) {
            throw new IllegalStateException(new UncheckedText((Text)new FormattedText("Couldn't post to '%s'", new Object[]{path})).asString());
        }
    }

    @Override
    public String patch(String path, AccessToken token, Jsonable body) {
        return this.patch(path, token, (HttpEntity)new StringEntity(body.asString(), ContentType.create((String)"application/json", (Charset)StandardCharsets.UTF_8)), 200);
    }

    private static final class AuthorizationHeader
    implements Header {
        private final String token;

        private AuthorizationHeader(String token) {
            this.token = token;
        }

        public HeaderElement[] getElements() throws ParseException {
            return new HeaderElement[]{new BasicHeaderElement(this.getName(), this.getValue())};
        }

        public String getName() {
            return "Authorization";
        }

        public String getValue() {
            return "Bearer " + this.token;
        }
    }
}

