/*
 * Decompiled with CFR 0.152.
 */
package org.proshin.finapi.label;

import org.apache.http.NameValuePair;
import org.json.JSONArray;
import org.json.JSONObject;
import org.proshin.finapi.accesstoken.AccessToken;
import org.proshin.finapi.endpoint.Endpoint;
import org.proshin.finapi.label.FpLabel;
import org.proshin.finapi.label.Label;
import org.proshin.finapi.label.Labels;
import org.proshin.finapi.label.in.LabelsCriteria;
import org.proshin.finapi.primitives.IterableJsonArray;
import org.proshin.finapi.primitives.paging.FpPage;
import org.proshin.finapi.primitives.paging.Page;

public final class FpLabels
implements Labels {
    private final Endpoint endpoint;
    private final AccessToken token;
    private final String url;

    public FpLabels(Endpoint endpoint, AccessToken token) {
        this(endpoint, token, "/api/v1/labels");
    }

    public FpLabels(Endpoint endpoint, AccessToken token, String url) {
        this.endpoint = endpoint;
        this.token = token;
        this.url = url;
    }

    @Override
    public Label one(Long id) {
        return new FpLabel(this.endpoint, this.token, new JSONObject(this.endpoint.get(this.url + '/' + id, this.token, new NameValuePair[0])), this.url);
    }

    @Override
    public Page<Label> query(LabelsCriteria criteria) {
        return new FpPage<Label>("labels", new JSONObject(this.endpoint.get(this.url, this.token, criteria)), (array, index) -> new FpLabel(this.endpoint, this.token, array.getJSONObject(index.intValue()), this.url));
    }

    @Override
    public Label create(String name) {
        return new FpLabel(this.endpoint, this.token, new JSONObject(this.endpoint.post(this.url, this.token, () -> new JSONObject().put("name", (Object)name), 201)), this.url);
    }

    @Override
    public Iterable<Long> deleteAll() {
        return new IterableJsonArray<Long>(new JSONArray((Object)new JSONObject(this.endpoint.delete(this.url, this.token, new NameValuePair[0])).getJSONArray("identifiers")), JSONArray::getLong);
    }
}

