/*
 * Decompiled with CFR 0.152.
 */
package org.proshin.finapi.mandator.in;

import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.http.NameValuePair;
import org.proshin.finapi.primitives.StringOf;
import org.proshin.finapi.primitives.pair.UrlEncodedPair;

public final class UsersCriteria
implements Iterable<NameValuePair> {
    private final List<NameValuePair> pairs;

    public UsersCriteria() {
        this(new ArrayList<NameValuePair>());
    }

    public UsersCriteria(List<NameValuePair> pairs) {
        this.pairs = pairs;
    }

    public UsersCriteria withMinRegistrationDate(OffsetDateTime minRegistrationDate) {
        this.pairs.add(new UrlEncodedPair("minRegistrationDate", new StringOf(minRegistrationDate)));
        return this;
    }

    public UsersCriteria withMaxRegistrationDate(OffsetDateTime maxRegistrationDate) {
        this.pairs.add(new UrlEncodedPair("maxRegistrationDate", new StringOf(maxRegistrationDate)));
        return this;
    }

    public UsersCriteria withMinDeletionDate(OffsetDateTime minDeletionDate) {
        this.pairs.add(new UrlEncodedPair("minDeletionDate", new StringOf(minDeletionDate)));
        return this;
    }

    public UsersCriteria withMaxDeletionDate(OffsetDateTime maxDeletionDate) {
        this.pairs.add(new UrlEncodedPair("maxDeletionDate", new StringOf(maxDeletionDate)));
        return this;
    }

    public UsersCriteria withMinLastActiveDate(OffsetDateTime minLastActiveDate) {
        this.pairs.add(new UrlEncodedPair("minLastActiveDate", new StringOf(minLastActiveDate)));
        return this;
    }

    public UsersCriteria withMaxLastActiveDate(OffsetDateTime maxLastActiveDate) {
        this.pairs.add(new UrlEncodedPair("maxLastActiveDate", new StringOf(maxLastActiveDate)));
        return this;
    }

    public UsersCriteria withMonthlyStats() {
        this.pairs.add(new UrlEncodedPair("includeMonthlyStats", true));
        return this;
    }

    public UsersCriteria withMonthlyStatsStartDate(OffsetDateTime monthlyStatsStartDate) {
        this.pairs.add(new UrlEncodedPair("monthlyStatsStartDate", new StringOf(monthlyStatsStartDate)));
        return this;
    }

    public UsersCriteria withMonthlyStatsEndDate(OffsetDateTime monthlyStatsEndDate) {
        this.pairs.add(new UrlEncodedPair("monthlyStatsEndDate", new StringOf(monthlyStatsEndDate)));
        return this;
    }

    public UsersCriteria withMinBankConnectionCountInMonthlyStats(int minBankConnectionCountInMonthlyStats) {
        this.pairs.add(new UrlEncodedPair("minBankConnectionCountInMonthlyStats", minBankConnectionCountInMonthlyStats));
        return this;
    }

    public UsersCriteria withUserId(String userId) {
        this.pairs.add(new UrlEncodedPair("userId", userId));
        return this;
    }

    public UsersCriteria withIsDeleted(boolean isDeleted) {
        this.pairs.add(new UrlEncodedPair("isDeleted", isDeleted));
        return this;
    }

    public UsersCriteria withIsLocked(boolean isLocked) {
        this.pairs.add(new UrlEncodedPair("isLocked", isLocked));
        return this;
    }

    public UsersCriteria withPage(int page, int perPage) {
        this.pairs.add(new UrlEncodedPair("page", page));
        this.pairs.add(new UrlEncodedPair("perPage", perPage));
        return this;
    }

    public UsersCriteria orderBy(String ... orders) {
        for (String order : orders) {
            this.pairs.add(new UrlEncodedPair("order", order));
        }
        return this;
    }

    @Override
    public Iterator<NameValuePair> iterator() {
        return this.pairs.iterator();
    }
}

