/*
 * Decompiled with CFR 0.152.
 */
package org.proshin.finapi.mock.in;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.function.Supplier;
import org.json.JSONObject;
import org.proshin.finapi.Jsonable;
import org.proshin.finapi.primitives.StringOf;

public final class Transaction
implements Jsonable {
    private final Supplier<? extends JSONObject> origin;

    public Transaction(BigDecimal amount) {
        this(() -> new JSONObject().put("amount", (Object)amount));
    }

    public Transaction(Supplier<? extends JSONObject> origin) {
        this.origin = origin;
    }

    public Transaction withPurpose(String purpose) {
        return new Transaction(() -> this.origin.get().put("purpose", (Object)purpose));
    }

    public Transaction withCounterpart(String counterpart) {
        return new Transaction(() -> this.origin.get().put("counterpart", (Object)counterpart));
    }

    public Transaction withCounterpartIban(String counterpartIban) {
        return new Transaction(() -> this.origin.get().put("counterpartIban", (Object)counterpartIban));
    }

    public Transaction withCounterpartBlz(String counterpartBlz) {
        return new Transaction(() -> this.origin.get().put("counterpartBlz", (Object)counterpartBlz));
    }

    public Transaction withCounterpartBic(String counterpartBic) {
        return new Transaction(() -> this.origin.get().put("counterpartBic", (Object)counterpartBic));
    }

    public Transaction withCounterpartAccountNumber(String counterpartAccountNumber) {
        return new Transaction(() -> this.origin.get().put("counterpartAccountNumber", (Object)counterpartAccountNumber));
    }

    public Transaction withBookingDate(LocalDate bookingDate) {
        return new Transaction(() -> this.origin.get().put("bookingDate", (Object)new StringOf(bookingDate)));
    }

    public Transaction withValueDate(LocalDate valueDate) {
        return new Transaction(() -> this.origin.get().put("valueDate", (Object)new StringOf(valueDate)));
    }

    @Override
    public JSONObject asJson() {
        return this.origin.get();
    }
}

