/*
 * Decompiled with CFR 0.152.
 */
package org.proshin.finapi.notificationrule;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.apache.http.NameValuePair;
import org.json.JSONObject;
import org.proshin.finapi.accesstoken.AccessToken;
import org.proshin.finapi.endpoint.Endpoint;
import org.proshin.finapi.notificationrule.NotificationRule;
import org.proshin.finapi.notificationrule.TriggerEvent;
import org.proshin.finapi.primitives.optional.OptionalStringOf;

public final class FpNotificationRule
implements NotificationRule {
    private final Endpoint endpoint;
    private final AccessToken token;
    private final JSONObject origin;
    private final String url;

    public FpNotificationRule(Endpoint endpoint, AccessToken token, JSONObject origin, String url) {
        this.endpoint = endpoint;
        this.token = token;
        this.origin = origin;
        this.url = url;
    }

    @Override
    public Long id() {
        return this.origin.getLong("id");
    }

    @Override
    public TriggerEvent triggerEvent() {
        return TriggerEvent.valueOf(this.origin.getString("triggerEvent"));
    }

    @Override
    public Map<String, Object> params() {
        String field = "params";
        return this.origin.isNull("params") ? Collections.emptyMap() : this.origin.getJSONObject("params").toMap();
    }

    @Override
    public Optional<String> callbackHandle() {
        return new OptionalStringOf(this.origin, "callbackHandle").get();
    }

    @Override
    public boolean includeDetails() {
        return this.origin.getBoolean("includeDetails");
    }

    @Override
    public void delete() {
        this.endpoint.delete(this.url + '/' + this.id(), this.token, new NameValuePair[0]);
    }
}

