/*
 * Decompiled with CFR 0.152.
 */
package org.proshin.finapi.payment;

import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.util.Optional;
import org.json.JSONObject;
import org.proshin.finapi.payment.Payment;
import org.proshin.finapi.payment.out.Status;
import org.proshin.finapi.payment.out.Type;
import org.proshin.finapi.primitives.OffsetDateTimeOf;
import org.proshin.finapi.primitives.optional.OptionalOf;
import org.proshin.finapi.primitives.optional.OptionalOffsetDateTimeOf;

public class FpPayment
implements Payment {
    private final JSONObject origin;

    public FpPayment(JSONObject origin) {
        this.origin = origin;
    }

    @Override
    public Long id() {
        return this.origin.getLong("id");
    }

    @Override
    public Long accountId() {
        return this.origin.getLong("accountId");
    }

    @Override
    public Type type() {
        return Type.valueOf(this.origin.getString("type"));
    }

    @Override
    public BigDecimal amount() {
        return this.origin.getBigDecimal("amount");
    }

    @Override
    public int orderCount() {
        return this.origin.getInt("orderCount");
    }

    @Override
    public Status status() {
        return Status.valueOf(this.origin.getString("status"));
    }

    @Override
    public Optional<String> bankMessage() {
        return new OptionalOf<String>(this.origin, "bankMessage", JSONObject::getString).get();
    }

    @Override
    public OffsetDateTime requestDate() {
        return new OffsetDateTimeOf(this.origin.getString("requestDate")).get();
    }

    @Override
    public Optional<OffsetDateTime> executionDate() {
        return new OptionalOffsetDateTimeOf(this.origin, "executionDate").get();
    }
}

