/*
 * Decompiled with CFR 0.152.
 */
package org.proshin.finapi.primitives;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import org.json.JSONArray;

public final class IterableJsonArray<T>
implements Iterable<T> {
    private final JSONArray array;
    private final BiFunction<JSONArray, Integer, T> func;

    public IterableJsonArray(JSONArray array, BiFunction<JSONArray, Integer, T> func) {
        this.array = array;
        this.func = func;
    }

    @Override
    public Iterator<T> iterator() {
        return new JsonArrayIterator<T>(this.array, this.func);
    }

    private static final class JsonArrayIterator<T>
    implements Iterator<T> {
        private final AtomicInteger index;
        private final JSONArray array;
        private final BiFunction<? super JSONArray, ? super Integer, ? extends T> func;

        JsonArrayIterator(JSONArray array, BiFunction<? super JSONArray, ? super Integer, ? extends T> func) {
            this(new AtomicInteger(0), array, func);
        }

        JsonArrayIterator(AtomicInteger index, JSONArray array, BiFunction<? super JSONArray, ? super Integer, ? extends T> func) {
            this.index = index;
            this.array = array;
            this.func = func;
        }

        @Override
        public boolean hasNext() {
            return this.index.get() < this.array.length();
        }

        @Override
        public T next() {
            int next = this.index.getAndIncrement();
            if (next >= this.array.length()) {
                throw new NoSuchElementException(String.format("Array has %d items when you tried to get an item with index=%d", this.array.length(), next));
            }
            return this.func.apply((JSONArray)this.array, next);
        }
    }
}

