/*
 * Decompiled with CFR 0.152.
 */
package org.proshin.finapi.tppcertificate;

import java.time.LocalDate;
import java.util.Optional;
import org.apache.http.NameValuePair;
import org.json.JSONObject;
import org.proshin.finapi.accesstoken.AccessToken;
import org.proshin.finapi.endpoint.Endpoint;
import org.proshin.finapi.primitives.optional.OptionalLocalDateOf;
import org.proshin.finapi.primitives.optional.OptionalStringOf;
import org.proshin.finapi.tppcertificate.CertificateType;
import org.proshin.finapi.tppcertificate.TppCertificate;

public class FpTppCertificate
implements TppCertificate {
    private final Endpoint endpoint;
    private final AccessToken token;
    private final JSONObject origin;
    private final String url;

    public FpTppCertificate(Endpoint endpoint, AccessToken token, JSONObject origin, String url) {
        this.endpoint = endpoint;
        this.token = token;
        this.origin = origin;
        this.url = url;
    }

    @Override
    public Long id() {
        return this.origin.getLong("id");
    }

    @Override
    public CertificateType type() {
        return CertificateType.valueOf(this.origin.getString("certificateType"));
    }

    @Override
    public Optional<String> label() {
        return new OptionalStringOf(this.origin, "label").get();
    }

    @Override
    public Optional<LocalDate> validFrom() {
        return new OptionalLocalDateOf(this.origin, "validFrom").get();
    }

    @Override
    public Optional<LocalDate> validUntil() {
        return new OptionalLocalDateOf(this.origin, "validUntil").get();
    }

    @Override
    public void delete() {
        this.endpoint.delete(this.url + '/' + this.id(), this.token, new NameValuePair[0]);
    }
}

