/*
 * Decompiled with CFR 0.152.
 */
package org.proshin.finapi.transaction;

import org.apache.http.NameValuePair;
import org.json.JSONArray;
import org.json.JSONObject;
import org.proshin.finapi.accesstoken.AccessToken;
import org.proshin.finapi.endpoint.Endpoint;
import org.proshin.finapi.primitives.IterableJsonArray;
import org.proshin.finapi.transaction.FpTransaction;
import org.proshin.finapi.transaction.Transaction;
import org.proshin.finapi.transaction.Transactions;
import org.proshin.finapi.transaction.in.DeleteTransactionsCriteria;
import org.proshin.finapi.transaction.in.EditTransactionsParameters;
import org.proshin.finapi.transaction.in.TransactionsCriteria;
import org.proshin.finapi.transaction.out.FpTransactionsPage;
import org.proshin.finapi.transaction.out.TransactionsPage;

public final class FpTransactions
implements Transactions {
    private final Endpoint endpoint;
    private final AccessToken token;
    private final String url;

    public FpTransactions(Endpoint endpoint, AccessToken token) {
        this(endpoint, token, "/api/v1/transactions");
    }

    public FpTransactions(Endpoint endpoint, AccessToken token, String url) {
        this.endpoint = endpoint;
        this.token = token;
        this.url = url;
    }

    @Override
    public Transaction one(Long id) {
        return new FpTransaction(this.endpoint, this.token, new JSONObject(this.endpoint.get(this.url + '/' + id, this.token, new NameValuePair[0])), this.url);
    }

    @Override
    public TransactionsPage query(TransactionsCriteria criteria) {
        return new FpTransactionsPage(this.endpoint, this.token, new JSONObject(this.endpoint.get(this.url, this.token, criteria)), this.url);
    }

    @Override
    public Iterable<Long> edit(EditTransactionsParameters parameters) {
        return new IterableJsonArray<Long>(new JSONObject(this.endpoint.patch(this.url, this.token, parameters)).getJSONArray("identifiers"), JSONArray::getLong);
    }

    @Override
    public void triggerCategorization(Iterable<Long> bankConnections) {
        JSONObject parameters = new JSONObject();
        for (Long bankConnection : bankConnections) {
            parameters.append("bankConnectionIds", (Object)bankConnection);
        }
        this.endpoint.post(this.url + "/triggerCategorization", this.token, () -> parameters);
    }

    @Override
    public Iterable<Long> deleteAll(DeleteTransactionsCriteria criteria) {
        return new IterableJsonArray<Long>(new JSONObject(this.endpoint.delete(this.url, this.token, criteria)).getJSONArray("identifiers"), JSONArray::getLong);
    }
}

